function lambda = findlambdaTh(A, D_0) 
% find the maximum lambda such that Z = 0 and Q'is positive semidefinite
% but will be indefinite with any larger lambda

N = D_0 * A^-1 * D_0 + D_0;
lambda_min= 1/max(real(eig(N))); % this lambda is guaranteed to have a PSD Q'
lambda_max = 1/(min(real(eig(D_0)))/sqrt(max(real(eig(A)))))^2; % this lambda suppose to lead to 
%an indefinite Q'

tol1=1e-5; % tolerance
tol2=1e-5;
a = lambda_min;
b = lambda_max;
   while b - a >tol1
       c = (a + b) / 2;
       Q = (1/c * A + 1/4 * A^2)^0.5 - 1/2 * A - D_0;
       if abs( min(real(eig(Q))) )<= tol2
           lambda = c;
           break
       elseif min(real(eig(Q))) > tol2
           a = c;
       else
           b = c;
       end
       lambda = a;
   end 
