% ns = 3;
% nr = 3;
% nz = 3;
% PN = 1; % sigma^2 = PN/nr
% Ps = 10; % signal power limit
% vr = 1; % variance of elements of legitimate channel
% vz = 1; % variance of elements of jamming channel
% 
% Hr = sqrt(2*vr)/2*randn(nr,ns)+ sqrt(2*vr)/2*1i*randn(nr,ns); %variance vr
% Hz = sqrt(2*vz)/2*randn(nr,nz)+ sqrt(2*vz)/2*1i*randn(nr,nz); %variance vz
% [Dr, Drb, Ur, Dzb, Uz] = ChannelSVD(Hr, Hz);
% 
% Dpr = Dr * Dr'; % legitimate channel power gain
% [l, Pa_m] = Fast_WF(Dpr, PN/nr, Ps);
% 
% %------------ find B, Btilde and the lower bound rate R_p -----------------
% B = Uz'*Ur*Dpr*Pa_m*Ur'*Uz; % B
% rz = size(Dzb, 1);
% if rz < nr
%     B11 = B(1 : rz, 1 : rz);
%     B12 = B(1 : rz, rz + 1 : nr);
%     B21 = B(rz + 1 : nr, 1 : rz);
%     B22 = B(rz + 1 : nr, rz + 1 : nr);
%     Btilde = B11 - B12 * ((PN/nr * eye(nr - rz) + B22)\eye(size(B22))) * B21;
%     %R_p = real(log2(det(eye(nr - rz) + 1 / PN/nr * B22))); %R+, the unjammed part
% else
%     Btilde = B;
%     %R_p = 0; %R+, the unjammed part
% end

Dzb_inv = Dzb\eye(size(Dzb));
A = Dzb_inv * Btilde * Dzb_inv';
D_0 = PN/nr * Dzb_inv * Dzb_inv'; 

Pz_v  = 0.1 : 0.1 : 1.5;
Em = zeros(3, length(Pz_v)); %eigenvalue matrix of M5

for i =  1: length(Pz_v)

Pz = Pz_v(i);
    
delta = 1; % delta is the diference between the solutions in two iterations 
n = size(D_0,1);
X_0 = Pz/n * eye(n);


while(delta > 10^-2)
    
inv_term = (X_0 + A + D_0)\eye(n);

cvx_begin SDP;
variable X(n,n) hermitian;
variable alp;
minimize alp - log_det(X + D_0);
1/log(2) *log_det(X_0 + A + D_0)+ real(trace(inv_term*X))-real(trace(inv_term*X_0)) <= alp;
trace(X) <= Pz; %sum(diag(X))<=1;
X >= 0;
cvx_end;

Delta = X - X_0;
delta = norm(Delta, 'fro');
X_0 = X;
end

eig(X);

M1 = (X + 1/2 *A + D_0); % intermidiate result 1
M2 = A^-0.5 * M1 * A^-0.5;
M3 = M2^2 - 1/4 * eye(size(D_0));
M4 = A^0.5 * M3 * A^0.5;
M5 = M4^-1;
% Z + lambda *I
eig(M5);
Ex(:, i) = eig(X);
Em(:, i) = eig(M5);

end