% clear
% ns = 4;
% nr = 3;
% nz = 3;
% PN = 1; % sigma^2 = PN/nr
% Ps = 10; % signal power limit
% vr = 1; % variance of elements of legitimate channel
% vz = 1; % variance of elements of jamming channel
% 
% Hr = sqrt(2*vr)/2*randn(nr,ns)+ sqrt(2*vr)/2*1i*randn(nr,ns); %variance vr
% Hz = sqrt(2*vz)/2*randn(nr,nz)+ sqrt(2*vz)/2*1i*randn(nr,nz); %variance vz
% [Dr, Drb, Ur, Dzb, Uz] = ChannelSVD(Hr, Hz);
% 
% Dpr = Dr * Dr'; % legitimate channel power gain
% [l, Pa_m] = Fast_WF(Dpr, PN/nr, Ps);
% 
% %------------ find B, Btilde and the lower bound rate R_p -----------------
% B = Uz'*Ur*Dpr*Pa_m*Ur'*Uz; % B
% rz = size(Dzb, 1);
% if rz < nr
%     B11 = B(1 : rz, 1 : rz);
%     B12 = B(1 : rz, rz + 1 : nr);
%     B21 = B(rz + 1 : nr, 1 : rz);
%     B22 = B(rz + 1 : nr, rz + 1 : nr);
%     Btilde = B11 - B12 * ((PN/nr * eye(nr - rz) + B22)\eye(size(B22))) * B21;
%     %R_p = real(log2(det(eye(nr - rz) + 1 / PN/nr * B22))); %R+, the unjammed part
% else
%     Btilde = B;
%     %R_p = 0; %R+, the unjammed part
% end

%------------ find A, positive eigenvalues and eigenvectors of A-----------
Dzb_inv = Dzb\eye(size(Dzb));
A = Dzb_inv * Btilde * Dzb_inv';
D_0 = PN/nr * Dzb_inv * Dzb_inv'; 

Pz = 10;
DC(Pz, A, D_0);

N = D_0 * A^-1 * D_0 + D_0;
lambda_th = 1/max(real(eig(N)));
P_th = real (trace( (1/0.97 * A + 1/4 * A^2)^0.5 - 1/2 * A - D_0)); 
% threshold (minimum) jamming power for Z = 0;
l = lambda_th : 0.001 : lambda_th + 0.01;
for i = 1: length(l)
Q = (1/l(i) * A + 1/4 * A^2)^0.5 - 1/2 * A - D_0;
v(i) = min(real(eig(Q)));
end
plot (l, v);
xlabel('l');
ylabel('v_min');
grid on;

Pz_th = 1.143176;
l = 1.0025187;
Q = (1/l * A + 1/4 * A^2)^0.5 - 1/2 * A - D_0;
Qz = A^0.5 * (A^-0.5 * (l*eye(size(D_0)) + Z)^-1 * A^-0.5 + 1/4 * eye(size(D_0)))^0.5 * A^0.5 - 1/2 * A - D_0;
T1 = 1/l * eye(size(D_0)) - N;
T2 = (0.5 * eye(size(D_0)) + A^-0.5 * D_0 * A^-0.5)^-1 * (1/l * A^-1 + 0.25 * eye(size(D_0))) * (0.5 * eye(size(D_0)) + A^-0.5 * D_0 * A^-0.5)^-1 - eye(size(D_0));
T3 = ( (0.5 * eye(size(D_0)) + A^-0.5 * D_0 * A^-0.5)^-1 * (1/l * A^-1 + 0.25 * eye(size(D_0))) * (0.5 * eye(size(D_0)) + A^-0.5 * D_0 * A^-0.5)^-1)^ 0.5 - eye(size(D_0));
T4 = (0.5 * eye(size(D_0)) + A^-0.5 * D_0 * A^-0.5)^-0.5 * (1/l * A^-1 + 0.25 * eye(size(D_0)))^0.5 * (0.5 * eye(size(D_0)) + A^-0.5 * D_0 * A^-0.5)^-0.5 - eye(size(D_0));
T5 = (0.5 * eye(size(D_0)) + A^-0.5 * D_0 * A^-0.5)^-0.5 * A^-0.5 * Q * A^-0.5 * (0.5 * eye(size(D_0)) + A^-0.5 * D_0 * A^-0.5)^-0.5;

M1 = (X + 1/2 *A + D_0); % intermidiate result 1
M2 = A^-0.5 * M1 * A^-0.5;
M3 = M2^2 - 1/4 * eye(size(D_0));
M4 = A^0.5 * M3 * A^0.5;
M5 = M4^-1;
% Z + lambda *I
eig(M5)
%Z = M5 - l * eye(size(D_0))