function [Ro_average_v, Rp_average_v] = RatesAverage(Ps_v, PN, ns, nr, nz, vr, vz, iter_max)
  
Rp_average_v = zeros(1, length(Ps_v)); % lower bound rate
Ro_average_v = zeros(1, length(Ps_v)); %unjammed rate 

for ii = 1: length(Ps_v)
    Ps = Ps_v(ii);
    Rp_sum = 0;
    Ro_sum = 0;

    for kk = 1: iter_max
        Hr = sqrt(2*vr)/2*randn(nr,ns)+ sqrt(2*vr)/2*1i*randn(nr,ns); 
        Hz = sqrt(2*vz)/2*randn(nr,nz)+ sqrt(2*vz)/2*1i*randn(nr,nz); 

        [Dr, Drb, Ur, Dzb, Uz] = ChannelSVD(Hr, Hz);

        Dpr = Dr* Dr'; % legitimate channel power gain
        [l, Pa_m] = Fast_WF(Dpr, PN/nr, Ps);
        B = Uz'*Ur*Dpr*Pa_m*Ur'*Uz; %
        %-------------find the unjammed rate Ro---------------------
        Ro = real(log2(det(eye(nr) + B / (PN/nr) )));
        %------------ find the lower bound rate R_p -----------------
        
        rz = size(Dzb, 1);
        if rz < nr
            B22 = B(rz + 1 : nr, rz + 1 : nr);
            Rp = real(log2(det(eye(nr - rz) + 1 / (PN/nr) * B22))); %R+, the unjammed part
        else
            Rp = 0; %R+, the unjammed part
        end
        Rp_sum = Rp_sum + Rp;
        Ro_sum = Ro_sum + Ro;
    end
    Rp_average_v(ii) = Rp_sum/iter_max;
    Ro_average_v(ii) = Ro_sum/iter_max;
end