clear
PN = 1; % sigma^2 = PN/nr
vr = 1; % variance of elements of legitimate channel
vz = 1; % variance of elements of jamming channel
iter_max = 10000;
Ps_v = logspace(-1, 2, 20)*PN; % legitmate transmission power range
dBPs = 10*log10(Ps_v/PN); % Pr/PN in dB

%------------------------------------------------------------------------------------------%
fh_lower = figure;
fh_unjam = figure;

%--------------------------------------------------------------------------
ns = 4;
nr = 4;
nz = 1;
[Ro_average_v, Rp_average_v] = RatesAverage(Ps_v, PN, ns, nr, nz, vr, vz, iter_max);
figure(fh_lower)
plot(dBPs, Rp_average_v, 'k.-' )
hold on
figure(fh_unjam)
plot(dBPs, Rp_average_v./Ro_average_v, 'k.-' )
hold on
%--------------------------------------------------------------------------

ns = 4;
nr = 4;
nz = 2;
[Ro_average_v, Rp_average_v] = RatesAverage(Ps_v, PN, ns, nr, nz, vr, vz, iter_max);
figure(fh_lower)
plot(dBPs, Rp_average_v, 'k-' )
figure(fh_unjam)
plot(dBPs, Rp_average_v./Ro_average_v, 'k-' )

%--------------------------------------------------------------------------
ns = 4;
nr = 4;
nz = 3;
[Ro_average_v, Rp_average_v] = RatesAverage(Ps_v, PN, ns, nr, nz, vr, vz, iter_max);
figure(fh_lower)
plot(dBPs, Rp_average_v, 'k+-' )
figure(fh_unjam)
plot(dBPs, Rp_average_v./Ro_average_v, 'k+-' )

%--------------------------------------------------------------------------
ns = 4;
nr = 4;
nz = 4;
[Ro_average_v, Rp_average_v] = RatesAverage(Ps_v, PN, ns, nr, nz, vr, vz, iter_max);
figure(fh_lower)
plot(dBPs, Rp_average_v, 'kd-' )
figure(fh_unjam)
plot(dBPs, Rp_average_v./Ro_average_v, 'kd-' )
%--------------------------------------------------------------------------
ns = 5;
nr = 3;
nz = 2;
[Ro_average_v, Rp_average_v] = RatesAverage(Ps_v, PN, ns, nr, nz, vr, vz, iter_max);
figure(fh_lower)
plot(dBPs, Rp_average_v, 'k*-' )
figure(fh_unjam)
plot(dBPs, Rp_average_v./Ro_average_v, 'k*-' )

%--------------------------------------------------------------------------
ns = 5;
nr = 3;
nz = 3;
[Ro_average_v, Rp_average_v] = RatesAverage(Ps_v, PN, ns, nr, nz, vr, vz, iter_max);
figure(fh_lower)
plot(dBPs, Rp_average_v, 'ks-' )
figure(fh_unjam)
plot(dBPs, Rp_average_v./Ro_average_v, 'ks-' )
%--------------------------------------------------------------------------

figure(fh_lower)
set(0, 'defaulttextinterpreter','latex');
box on 
grid on
xlabel('$P_\mathrm{t}$~(dB)')
ylabel('$R^0$')
legend('$n_\mathrm{t} = 4, n_\mathrm{r} = 4, n_\mathrm{z} = 1$', ...
'$n_\mathrm{t} = 4, n_\mathrm{r} = 4, n_\mathrm{z} = 2$', ...
'$n_\mathrm{t} = 4, n_\mathrm{r} = 4, n_\mathrm{z} = 3$', ...
'$n_\mathrm{t} = 4, n_\mathrm{r} = 4, n_\mathrm{z} = 4$', ...
'$n_\mathrm{t} = 5, n_\mathrm{r} = 3, n_\mathrm{z} = 2$', ...
'$n_\mathrm{t} = 5, n_\mathrm{r} = 3, n_\mathrm{z} = 3$')
hold off

figure(fh_unjam)
set(0, 'defaulttextinterpreter','latex');
box on 
grid on
xlabel('$P_\mathrm{t}$~(dB)')
ylabel('$R^0/R^\mathrm{m}$')
legend('$n_\mathrm{t} = 4, n_\mathrm{r} = 4, n_\mathrm{z} = 1$', ...
'$n_\mathrm{t} = 4, n_\mathrm{r} = 4, n_\mathrm{z} = 2$', ...
'$n_\mathrm{t} = 4, n_\mathrm{r} = 4, n_\mathrm{z} = 3$', ...
'$n_\mathrm{t} = 4, n_\mathrm{r} = 4, n_\mathrm{z} = 4$', ...
'$n_\mathrm{t} = 5, n_\mathrm{r} = 3, n_\mathrm{z} = 2$', ...
'$n_\mathrm{t} = 5, n_\mathrm{r} = 3, n_\mathrm{z} = 3$')
hold off

save lowerboundrate