function lambda = Jamming_WF(Uab, Vab, Pz) % P_z_max jamming power, Pi_z constant item (e.g. sigma^2 D_0)

l_min= 10^-3; % Dx= sqrt(Da/lambda+Da^2/4)-Da/2
while real(trace(Uab*(sqrt(1/l_min*Vab+1/4*Vab.^2)-1/2*Vab)*Uab'))> Pz
    l_min=10*l_min;
end
l_min=l_min/10;
l_max= 1000; % Dx= sqrt(Da/lambda+Da^2/4)-Da/2
while real(trace(Uab*(sqrt(1/l_max*Vab+1/4*Vab.^2)-1/2*Vab)*Uab'))< Pz
    l_max=l_max/10;
end
l_max=l_max*10;

tol1=1e-5;
tol2=1e-5;
lambda = l_min;
while l_max-l_min > tol1
    aveg=(l_max+l_min)/2;
    if abs(real(trace(Uab*(sqrt(1/aveg*Vab+1/4*Vab.^2)-1/2*Vab)*Uab'))-Pz)<=tol2
        lambda =aveg;
        break
    elseif real(trace(Uab*(sqrt(1/aveg*Vab+1/4*Vab.^2)-1/2*Vab)*Uab'))-Pz > tol2
        l_min=aveg;
    else
        l_max=aveg;
    end
    lambda =aveg;
end