clear
ns = 4;
nr = 3;
nz = 3;
PN = 1; % sigma^2 = PN/nr
Ps = 10; % signal power limit
vr = 1; % variance of elements of legitimate channel
vz = 1; % variance of elements of jamming channel
%------------------------------------------------------------------------------------------%
eta = 0.1;
Pz_v = logspace(0, 2, 20)*Ps; % jamming power as times of the noise power
channelratio_v = logspace(-1, 1, 20);
percentJamDominate_m = zeros(length(channelratio_v), length(Pz_v));

iter_max = 100;

for jj = 1: length(Pz_v)

    Pz = Pz_v(jj);
    
    for mm = 1: length(channelratio_v)
        
        vz = channelratio_v(mm) * vr;
        countJamDominate = 0;
        
        for kk = 1: iter_max

            Hr = sqrt(2*vr)/2*randn(nr,ns)+ sqrt(2*vr)/2*1i*randn(nr,ns); %variance vr
            Hz = sqrt(2*vz)/2*randn(nr,nz)+ sqrt(2*vz)/2*1i*randn(nr,nz); %variance vz
            [Dr, Drb, Ur, Dzb, Uz] = ChannelSVD(Hr, Hz);

            Dpr = Dr * Dr'; % legitimate channel power gain
            [l, Pa_m] = Fast_WF(Dpr, PN/nr, Ps);

            %------------ find B, Btilde and the lower bound rate R_p -----------------
            B = Uz'*Ur*Dpr*Pa_m*Ur'*Uz; % B
            rz = size(Dzb, 1);
            if rz < nr
                B11 = B(1 : rz, 1 : rz);
                B12 = B(1 : rz, rz + 1 : nr);
                B21 = B(rz + 1 : nr, 1 : rz);
                B22 = B(rz + 1 : nr, rz + 1 : nr);
                Btilde = B11 - B12 * ((PN/nr * eye(nr - rz) + B22)\eye(size(B22))) * B21;
                %R_p = real(log2(det(eye(nr - rz) + 1 / PN/nr * B22))); %R+, the unjammed part
            else
                Btilde = B;
                %R_p = 0; %R+, the unjammed part
            end

            %------------ find A, positive eigenvalues and eigenvectors of A-----------
            Dzb_inv = Dzb\eye(size(Dzb));
            A = Dzb_inv * Btilde * Dzb_inv';
            [Ua, Va] = eig(A);
            Va = real(Va);
            Va(Va < 1e-5) = 0;
            idx = (Va > 0);
            Vab = diag(Va(idx)); % \mathbf{\bar{\Lambda}}_\mathbf{A}
            Uab = Ua(: , find(diag(idx) == 1)); %#ok<FNDSB> % \mathbf{U}_{\mathbf{A}1}

            lambda = Jamming_WF(Uab, Vab, Pz);
            Qz_prime = Uab*(sqrt(1/lambda*Vab+1/4*Vab.^2)-1/2*Vab)*Uab'; % optimal Qz_prime in jammer dominant regime
            [Uq, Vq] = eig(Qz_prime);
            Vq = real(Vq);
            D = PN/nr*Dzb_inv.*Dzb_inv'; % \mathbf{D} = \sigma^2 \mathbf{\bar{\Omega}}_z^}{-1}\mathbf{\bar{\Omega}}_z^}{-H}
            s1 = real(trace(D));
            J = Uab'*(Qz_prime - D)*Uab; % Uab corresponds to positive eigenvalues of Qz
            cond1 = min(real(eig(J))); % > 0, cond1 satisfied
            cond2 = s1/Pz; % < eta, cond2 satisfied
            if (cond1 > 0 && cond2 <= eta)
                countJamDominate = countJamDominate + 1;
            end
        end        
        percentJamDominate_m(mm, jj) = countJamDominate/iter_max;        
    end
end

dBPower = 10*log10(Pz_v./Ps); % Pr/sigma^2 in dB
dBchannelratio = 10 * log10(channelratio_v);
save JammerDomRegime.mat

%-----------------------------------plot-----------------------------------
set(0, 'defaulttextinterpreter','latex');


figure(1)
mesh(dBPower, dBchannelratio,percentJamDominate_m)
xlabel('$P_\mathrm{z}/P_\mathrm{t}$~(dB)')
ylabel('$v_\mathrm{z}/v_\mathrm{r}$~(dB)')
zlabel('$P^{\rm JD}$')
