clear
ns = 4;
nr = 3;
nz = 3;
PN = 1; % sigma^2 = PN/nr
Ps = 10; % signal power limit
vr = 1; % variance of elements of legitimate channel
vz = 1; % variance of elements of jamming channel
%------------------------------------------------------------------------------------------%
eta = 0.1;
Pz_v = (1:8)*Ps; % jamming power as times of the noise power
R_jd_v = zeros(1, length(Pz_v)); % rate achieved by jammer-dominant solution 
R_dc_v = zeros(1, length(Pz_v)); % rate achieved by optimal jamming with dc programming
R_uni_v = zeros(1, length(Pz_v)); % rate achieved by uniform jamming power allocation
iter_max = 800;

for jj = 1: length(Pz_v)

    Pz = Pz_v(jj);
    R_jd_sum = 0;
    R_dc_sum = 0;
    R_uni_sum = 0;
        for kk = 1: iter_max

            Hr = sqrt(2*vr)/2*randn(nr,ns)+ sqrt(2*vr)/2*1i*randn(nr,ns); %variance vr
            Hz = sqrt(2*vz)/2*randn(nr,nz)+ sqrt(2*vz)/2*1i*randn(nr,nz); %variance vz
            [Dr, Drb, Ur, Dzb, Uz] = ChannelSVD(Hr, Hz);
            Dpr = Dr * Dr'; % legitimate channel power gain
            [l, Pa_m] = Fast_WF(Dpr, PN/nr, Ps);
            %------------ find B, Btilde and the lower bound rate R_p -----------------
            Qs = Ur * Dpr * Pa_m * Ur';
            B = Uz'* Qs *Uz; % B
            rz = size(Dzb, 1);
            if rz < nr
                B11 = B(1 : rz, 1 : rz);
                B12 = B(1 : rz, rz + 1 : nr);
                B21 = B(rz + 1 : nr, 1 : rz);
                B22 = B(rz + 1 : nr, rz + 1 : nr);
                Btilde = B11 - B12 * ((PN/nr * eye(nr - rz) + B22)\eye(nr - rz)) * B21;
                R_p = real(log2(det(eye(nr - rz) + 1 / PN/nr * B22))); %R+, the unjammed part
            else
                Btilde = B;
                R_p = 0;
            end
            %------------ find A, positive eigenvalues and eigenvectors of A-----------
            Dzb_inv = Dzb\eye(size(Dzb));
            A = Dzb_inv * Btilde * Dzb_inv';
            [Ua, Va] = eig(A);
            Va = real(Va);
            Va(Va < 1e-5) = 0;
            idx = (Va>0);
            Vab = diag(Va(idx)); % \mathbf{\bar{\Lambda}}_\mathbf{A}
            Uab = Ua(: , find(diag(idx) == 1)); %#ok<FNDSB> % \mathbf{U}_{\mathbf{A}1}

            lambda = Jamming_WF(Uab, Vab, Pz);
            Qz_prime = Uab * (sqrt(1/lambda * Vab + 1/4 * Vab.^2)- 1/2 * Vab) * Uab'; % optimal Qz_prime in jammer dominant regime
            JpN_inv = (Qz_prime + PN/nr * Dzb_inv * Dzb_inv')\eye(rz); % inverse of jamming + noise
            R_jd = R_p + real(log2(det(eye(rz) + A* JpN_inv))); % rate using proposed solution in jammer-dominant regime
            D_0 = PN/nr * Dzb_inv * Dzb_inv'; 
            R_dc = R_p + DC(Pz, A, D_0); % rate obtained using DC programming
            R_uni = real(log2(det(eye(nr) + Qs * ((Hz*Hz' * Pz/nz + PN/nr * eye(nr))\eye(nr)) ))); % rate obtained using uniform power allocation            
            
            R_jd_sum = R_jd_sum + R_jd;
            R_dc_sum = R_dc_sum + R_dc;
            R_uni_sum = R_uni_sum + R_uni; 
        end   
        
        R_jd_v(jj) = R_jd_sum/iter_max;
        R_dc_v(jj) = R_dc_sum/iter_max;
        R_uni_v(jj) = R_uni_sum/iter_max;

end

dBPower = 10*log10(Pz_v./Ps); % Pr/sigma^2 in dB

save JammedRatesCompare800.mat

%-----------------------------------plot-----------------------------------
set(0, 'defaulttextinterpreter','latex');

figure(1)
plot(dBPower, R_uni_v, 'kd-', dBPower, R_dc_v, 'ko-', dBPower, R_jd_v, 'ks-' )
legend('Uniform power allocation', 'Optimal numeric solution', 'Jammer-dominant solution' )
xlabel('$P_\mathrm{z}/P_\mathrm{t}$~(dB)')
ylabel('$R^{\rm J}$')
grid on
box on