function [Wl, Pa_m]= Fast_WF(DC, sigmaSquare, P_l)
% Calculate the water-level of waterfilling based power allocation and the
% optimal power allocatio matrix
%input DC: Square Diagonal matrix of All (including 0) (eigen) channel Power gains (norm), sigmaSquare: noise variance, P_l: power limit
%output: water-level 1/lambda

A = zeros(rank(DC));

jj = 1;
for ii=1:1:size(DC,1)
    if DC(ii,ii)> 0
        A(jj, jj) = sigmaSquare/DC(ii,ii);
        jj = jj + 1;
    end
end

r= rank(DC);% size of the Square Diagonal matrix
if P_l>trace(max(diag(A))*eye(r)-A)
   Wl=1/r*(P_l+trace(A));
else         % bisectional search for water level
   tol1=1e-5; % tolerance
   tol2=1e-5;
   a=min(diag(A));
   b=max(diag(A));
   while b-a>tol1
       c=(a+b)/2;
       if abs(trace((c*eye(r)-A).*(c*eye(r)-A>0))-P_l)<=tol2
           Wl=c;
           break
       elseif trace((c*eye(r)-A).*(c*eye(r)-A>0))-P_l>tol2
           b=c;
       else
           a=c;
       end
       Wl=a;
   end
end

Pa_m = zeros(size(DC));
for ii=1:1:size(DC,1)
    if DC(ii,ii)> 0
        Pa_m (ii, ii) = Wl - sigmaSquare/DC(ii,ii);
    end
end
Pa_m(Pa_m < 1e-5) = 0;
