clear
sigma = 0.1;
y = logspace(0,4,50); % y = \omega^2/\sigma^2
x = y.* sigma^2; % x = \omega^2
lambda = 0.1: 0.02: 0.5;
z = zeros(length(x),length(lambda));
for i = 1:length(x)
    for j = 1:length(lambda)
        z(i, j) = (1/lambda(j)* x(i)^-1 + 0.25*x(i)^-2)^0.5 - 0.5*x(i)^-1 - sigma^2*x(i)^-1;
    end
end

mesh(lambda, 10*log10(y), z);
set(0, 'defaulttextinterpreter','latex');
xlabel('$\lambda$')
ylabel('${\omega^2}/{\sigma^2}$~(dB)')
zlabel('$f(\omega, \lambda, \sigma^2)$')
