function  R_dc_jammedpart = DC(Pz, A, D_0) %Xany analytical optimal solution, 
                                               %Xalg optimal solution found by algorithm 

delta = 1; % delta is the diference between the solutions in two iterations 
n = size(D_0,1);
X_0 = Pz/n * eye(n);


while(delta > 10^-2)
    
inv_term = (X_0 + A + D_0)\eye(n);

cvx_begin SDP;
variable X(n,n) hermitian;
variable alp;
minimize alp - log_det(X + D_0);
1/log(2) *log_det(X_0 + A + D_0)+ real(trace(inv_term*X))-real(trace(inv_term*X_0)) <= alp;
trace(X) <= Pz; %sum(diag(X))<=1;
X >= 0;
cvx_end;

Delta = X - X_0;
delta = norm(Delta, 'fro');
X_0 = X;
end

JpN_inv = (X + D_0)\eye(n); %inverse of jamming plus noise
R_dc_jammedpart = real(log2(det(eye(n) + A * JpN_inv)));
