function [Dr, Drb, Ur, Dzb, Uz] = ChannelSVD(Hr, Hz)
%Dr/Dz SVD diagonal matrix including 0
%Drb/Dzb SVD diagonal matrix excluding 0

[Ur, Dr,] = svd(Hr);
Dr_copy = Dr*Dr';
Dr_copy(Dr_copy < 1e-6) = 0;
idx = (Dr_copy > 0);
Drb = diag(Dr(idx)); % contains only the positive elements of Dr


[Uz, Dz,] = svd(Hz);
Dz_copy = Dz*Dz';
Dz_copy(Dz_copy < 1e-6) = 0;
idx = (Dz_copy > 0);
Dzb = diag(Dz(idx)); % \mathbf{\bar{\omega}}_z




