function [R_uni_v, R_jd_v, R_opt_v] = CalcRatesChannelErr2(ns, nr, nz, Ps, Pz, PN, eps_max, nSample)

% ErrPlace indicates which channel estimation has error in both Hr and Hz

% eps_max : maximum error factor;
% nSample: number of sample points;
eps_v = 0 : eps_max/nSample : eps_max; % channel estimation error factor, the less the better
iter_max = 400; % no. of channel realizations
R_jd_v = zeros(length(eps_v), length(eps_v)); % rate achieved by jammer-dominant solution
R_uni_v = zeros(length(eps_v), length(eps_v)); % rate achieved by uniform jamming power allocation
R_opt_v = zeros(length(eps_v), length(eps_v));

for ii = 1 : length(eps_v)
    ii %#ok<NOPRT>
    err_Hr = eps_v(ii); % channel estimation error factor in Hr

    for jj = 1 : length(eps_v)

        err_Hz = eps_v(jj); % channel estimation error factor in Hz

        R_jd_sum = 0;
        R_uni_sum = 0;
        R_opt_sum = 0;

        for iter = 1 : iter_max
            Hr = sqrt(2)/2*randn(nr,ns) + sqrt(2)/2*1i*randn(nr,ns);
            Er = sqrt(2)/2*randn(nr,ns) + sqrt(2)/2*1i*randn(nr,ns);
            Hz = sqrt(2)/2*randn(nr,nz) + sqrt(2)/2*1i*randn(nr,nz);
            Ez = sqrt(2)/2*randn(nr,nz) + sqrt(2)/2*1i*randn(nr,nz);
            Hr_e = sqrt(1 - err_Hr^2)*Hr + err_Hr*Er;
            Hz_e = sqrt(1 - err_Hz^2)*Hz + err_Hz*Ez;

            [Dr_e, Drb_e, Ur_e, Dzb_e, Uz_e] = ChannelSVD(Hr_e, Hz_e);
            [Dr, Drb, Ur, Dzb, Uz] = ChannelSVD(Hr, Hz); %#ok<NASGU,NASGU>
            Dpr = Dr * Dr';
            Dpr_e = Dr_e * Dr_e'; % legitimate channel power gain
            [l, Pa_m] = Fast_WF(Dpr, PN/nr, Ps);
            [l_e, Pa_m_e] = Fast_WF(Dpr_e, PN/nr, Ps);
            %------------ find B, Btilde and the lower bound rate R_p -----------------
            Qs_e = Ur_e * Dpr_e * Pa_m_e * Ur_e';
            Qs = Ur * Dpr * Pa_m * Ur';
            B = Uz'* Qs *Uz; % B
            B_e = Uz_e'* Qs_e *Uz_e; % B
            rz_e = size(Dzb_e, 1);
            rz = size(Dzb, 1);
            if rz_e < nr
                B11_e = B_e(1 : rz_e, 1 : rz_e);
                B12_e = B_e(1 : rz_e, rz_e + 1 : nr);
                B21_e = B_e(rz_e + 1 : nr, 1 : rz_e);
                B22_e = B_e(rz_e + 1 : nr, rz_e + 1 : nr);
                Btilde_e = B11_e - B12_e * ((PN/nr * eye(nr - rz_e) + B22_e)\eye(nr - rz_e)) * B21_e;
                %R_p_e = real(log2(det(eye(nr - rz_e) + 1 / PN/nr * B22_e))); %R+, the unjammed part
            else
                Btilde_e = B_e;
                %R_p_e = 0;
            end
            if rz < nr
                B11 = B(1 : rz, 1 : rz);
                B12 = B(1 : rz, rz + 1 : nr);
                B21 = B(rz + 1 : nr, 1 : rz);
                B22 = B(rz + 1 : nr, rz + 1 : nr);
                Btilde = B11 - B12 * ((PN/nr * eye(nr - rz) + B22)\eye(nr - rz)) * B21;
                %R_p_e = real(log2(det(eye(nr - rz_e) + 1 / PN/nr * B22_e))); %R+, the unjammed part
            else
                Btilde = B;
                %R_p_e = 0;
            end
            %------------ find A, positive eigenvalues and eigenvectors of A-----------
            Dzb_inv_e = Dzb_e\eye(size(Dzb_e));
            A_e = Dzb_inv_e * Btilde_e * Dzb_inv_e';
            [Ua_e, Va_e] = eig(A_e);
            Va_e = real(Va_e);
            Va_e(Va_e < 1e-5) = 0;
            idx = (Va_e > 0);
            Vab_e = diag(Va_e(idx)); % \mathbf{\bar{\Lambda}}_\mathbf{A}
            Uab_e = Ua_e(: , find(diag(idx) == 1)); %#ok<FNDSB> % \mathbf{U}_{\mathbf{A}1}

             %------------ find jammer-dominant solution rate and uniform jamming rate -------------
            
            lambda_e = Jamming_WF(Uab_e, Vab_e, Pz);
            Qz_prime_e = Uab_e * (sqrt(1/lambda_e * Vab_e + 1/4 * Vab_e.^2)- 1/2 * Vab_e) * Uab_e'; % optimal Qz_prime in jammer dominant regime
            Qz_e = zeros(nz, nz);
            Qz_e(1 :rz_e, 1:rz_e) = Qz_prime_e;
            [temp1, temp2, Vz_e] = svd(Hz_e);
            Qz_e = Vz_e * Qz_e * Vz_e';
            R_jd_e = real(log2(det(eye(nr) + Qs * ((Hz*Qz_e*Hz' + PN/nr * eye(nr))\eye(nr)) ))); % rate using proposed solution in jammer-dominant regime
            %D_0 = PN/nr * Dzb_inv * Dzb_inv';
            %R_dc = R_p + DC(Pz, A, D_0); % rate obtained using DC programming
            R_uni = real(log2(det(eye(nr) + Qs * ((Hz*Hz' * Pz/nz + PN/nr * eye(nr))\eye(nr)) ))); % rate obtained using uniform power allocation

            %------------------ find theoretical worst-case rate -----------------------------------
            Dzb_inv = Dzb\eye(size(Dzb));
            A = Dzb_inv * Btilde * Dzb_inv';
            D_0 = PN/nr*Dzb_inv.*Dzb_inv';
            delta = 1;
            n = size(D_0, 1);
            X_0 = Pz/nr * eye(size(D_0));

            while(delta > 10^-2)

                inv_term = (X_0 + A + D_0)\eye(n);

                cvx_begin SDP;
                variable X(n,n) hermitian;
                variable alp;
                minimize alp - log_det(X + D_0);
                1/log(2) *log_det(X_0 + A + D_0)+ real(trace(inv_term*X))-real(trace(inv_term*X_0)) <= alp; %#ok<VUNUS>
                trace(X) <= Pz; %#ok<VUNUS> %sum(diag(X))<=1;
                X >= 0; %#ok<VUNUS>
                cvx_end;

                Delta = X - X_0;
                delta = norm(Delta, 'fro');
                X_0 = X;
            end

            R_opt = real(log2(det(eye(n) + A * ((X + D_0)\eye(n))))); %inverse of jamming plus noise
            
            if(isnan(R_opt))
                a = 0;
            end

            R_jd_sum = R_jd_sum + R_jd_e;
            R_uni_sum  = R_uni_sum + R_uni;
            R_opt_sum = R_opt_sum + R_opt;
        end
        R_jd_v(ii, jj) = R_jd_sum/iter_max;
        R_uni_v(ii, jj) = R_uni_sum/iter_max;
        R_opt_v(ii, jj) = R_opt_sum/iter_max;
    end
end