function [R_uni_v, R_jd_v] = CalcRatesChannelErr(ns, nr, nz, Ps, Pz, PN, eps_max, nSample, ErrPlace)

% ErrPlace indicates which channel estimation has error
% ErrPlace = 0: error in Hr
% ErrPlace = 1: error in Hz

% eps_max : maximum error factor;
% nSample: number of sample points;
eps_v = 0 : eps_max/nSample : eps_max; % channel estimation error factor, the less the better
iter_max = 3000; % no. of channel realizations
R_jd_v = zeros(1, length(eps_v)); % rate achieved by jammer-dominant solution
R_uni_v = zeros(1, length(eps_v)); % rate achieved by uniform jamming power allocation

for ii = 1 : length(eps_v)

    err = eps_v(ii); % channel estimation error factor in Hr
    R_jd_sum = 0;
    R_uni_sum = 0;

    for iter = 1 : iter_max
        Hr = sqrt(2)/2*randn(nr,ns) + sqrt(2)/2*1i*randn(nr,ns);
        Hz = sqrt(2)/2*randn(nr,nz) + sqrt(2)/2*1i*randn(nr,nz);

        if (ErrPlace == 0)
            Er = sqrt(2)/2*randn(nr,ns) + sqrt(2)/2*1i*randn(nr,ns);
            Hr_e = sqrt(1 - err^2)*Hr + err*Er;
            Hz_e = Hz;
        elseif (ErrPlace == 1)
            Ez = sqrt(2)/2*randn(nr,nz) + sqrt(2)/2*1i*randn(nr,nz);
            Hz_e = sqrt(1 - err^2)*Hz + err*Ez;
            Hr_e = Hr;
        end

        [Dr_e, Drb_e, Ur_e, Dzb_e, Uz_e] = ChannelSVD(Hr_e, Hz_e);
        [Dr, Drb, Ur, Dzb, Uz] = ChannelSVD(Hr, Hz); %#ok<NASGU,NASGU>
        Dpr = Dr * Dr';
        Dpr_e = Dr_e * Dr_e'; % legitimate channel power gain
        [l, Pa_m] = Fast_WF(Dpr, PN/nr, Ps);
        [l_e, Pa_m_e] = Fast_WF(Dpr_e, PN/nr, Ps);
        %------------ find B, Btilde and the lower bound rate R_p -----------------
        Qs_e = Ur_e * Dpr_e * Pa_m_e * Ur_e';
        Qs = Ur * Dpr * Pa_m * Ur';
        B_e = Uz_e'* Qs_e *Uz_e; % B
        rz_e = size(Dzb_e, 1);
        if rz_e < nr
            B11_e = B_e(1 : rz_e, 1 : rz_e);
            B12_e = B_e(1 : rz_e, rz_e + 1 : nr);
            B21_e = B_e(rz_e + 1 : nr, 1 : rz_e);
            B22_e = B_e(rz_e + 1 : nr, rz_e + 1 : nr);
            Btilde_e = B11_e - B12_e * ((PN/nr * eye(nr - rz_e) + B22_e)\eye(nr - rz_e)) * B21_e;
            %R_p_e = real(log2(det(eye(nr - rz_e) + 1 / PN/nr * B22_e))); %R+, the unjammed part
        else
            Btilde_e = B_e;
            %R_p_e = 0;
        end
        %------------ find A, positive eigenvalues and eigenvectors of A-----------
        Dzb_inv_e = Dzb_e\eye(size(Dzb_e));
        A_e = Dzb_inv_e * Btilde_e * Dzb_inv_e';
        [Ua_e, Va_e] = eig(A_e);
        Va_e = real(Va_e);
        Va_e(Va_e < 1e-5) = 0;
        idx = (Va_e > 0);
        Vab_e = diag(Va_e(idx)); % \mathbf{\bar{\Lambda}}_\mathbf{A}
        Uab_e = Ua_e(: , find(diag(idx) == 1)); %#ok<FNDSB> % \mathbf{U}_{\mathbf{A}1}

        lambda_e = Jamming_WF(Uab_e, Vab_e, Pz);
        Qz_prime_e = Uab_e * (sqrt(1/lambda_e * Vab_e + 1/4 * Vab_e.^2)- 1/2 * Vab_e) * Uab_e'; % optimal Qz_prime in jammer dominant regime
        Qz_e = zeros(nz, nz);
        Qz_e(1 :rz_e, 1:rz_e) = Qz_prime_e;
        [temp1, temp2, Vz_e] = svd(Hz_e);
        Qz_e = Vz_e * Qz_e * Vz_e';
        R_jd_e = real(log2(det(eye(nr) + Qs * ((Hz*Qz_e*Hz' + PN/nr * eye(nr))\eye(nr)) ))); % rate using proposed solution in jammer-dominant regime
        %D_0 = PN/nr * Dzb_inv * Dzb_inv';
        %R_dc = R_p + DC(Pz, A, D_0); % rate obtained using DC programming
        R_uni = real(log2(det(eye(nr) + Qs * ((Hz*Hz' * Pz/nz + PN/nr * eye(nr))\eye(nr)) ))); % rate obtained using uniform power allocation
        R_jd_sum = R_jd_sum + R_jd_e;
        R_uni_sum  = R_uni_sum + R_uni;
    end
    R_jd_v(ii) = R_jd_sum/iter_max;
    R_uni_v(ii) = R_uni_sum/iter_max;

end