function dif = CalCompQ(Pz, A, D_0)

lambda_th = findlambdaTh(A, D_0);
Q =  A^0.5 * (1/lambda_th * A^-1 + 1/4 * eye(size(D_0)))^0.5 * A^0.5 - 1/2 * A - D_0;

if (trace(Q) < Pz) %% Pz is larger than enough to make a PD Q'
    
    % find appropriate \lambda using bisectional method
    tol1=1e-5; % tolerance
    tol2=1e-5;
    a = 10^-3; % min lambda
    b = lambda_th;
    while b - a > tol1
        c = (a + b) / 2;
        Q = A^0.5 * (1/c * A^-1 + 1/4 * eye(size(D_0)))^0.5 * A^0.5 - 1/2 * A - D_0;
        if abs( Pz - real(trace(Q)) ) <= tol2
            lambda = c;
            break
        elseif Pz - real(trace(Q)) > tol2
            b = c;
        else
            a = c;
        end
        lambda = a;
    end
    Q = A^0.5 * (1/lambda * A^-1 + 1/4 * eye(size(D_0)))^0.5 * A^0.5 - 1/2 * A - D_0;
    
else  %% Pz is not large enough to make a PD Q'
    
    N = D_0 * A^-1 * D_0 + D_0;
    [Un, Vn] = eig(N^-1);
    [V, Ind] = sort(diag(Vn), 'descend'); %sort Vn
    U = zeros(size(Un)); 
    for i = 1:length(V) %sort Un
        U(:, i) = Un (: ,Ind(i));
    end
    V = diag(V);
    tol1=1e-5; % tolerance
    tol2=1e-5;
    a = lambda_th; % min lambda
    b = max(diag(V)); % max lambda
    while b - a > tol1
        c = (a + b) / 2;
        Dz = V - c * eye(size(D_0));
        Dz(Dz > - 1e-5) = 0; % project to negative orthant
        Z = U * Dz * U';
        Q = A^0.5 *( A^-0.5 * (c * eye(size(D_0)) +  Z )^-1 * A^-0.5 + 1/4 * eye(size(D_0)))^0.5 * A^0.5 - 1/2 * A - D_0;
        if abs( Pz - real(trace(Q)) ) <= tol2
            lambda = c;
            break
        elseif Pz - real(trace(Q)) > tol2
            b = c;
        else
            a = c;
        end
        lambda = a;
    end
    Q = A^0.5 *( A^-0.5 * (lambda * eye(size(D_0)) +  Z )^-1 * A^-0.5 + 1/4 * eye(size(D_0)))^0.5 * A^0.5 - 1/2 * A - D_0;
    
%----1----    
%     [V, Ind] = sort(diag(Vn), 'descend'); %sort Vn
%     U = zeros(size(Un)); 
%     for i = 1:length(V) %sort Un
%         U(:, i) = Un (: ,Ind(i));
%     end
%     nz = length(Vn);
%     
%     Zmin = zeros(size(D_0)); % minimum case Z is 0 (when Pz becomes large enough for PD Q')
%     Zmax = N^-1 -lambda_th * eye(size(D_0)); %maximum case Z is N^-1 (when Pz becomes to 0)
%     v_th = V(nz); % threshould for v 
%     for i = 1 : length(V)
%         dV = V(i) - v_th; % difference between the current eigenvalue and lambda
%         inc = U(:, nz - i + 1) * dV * U(:, nz - i + 1)'; % increase item (matrix) for Z_min
%         Z = Zmin + inc;
%         Q = A^0.5 *( A^-0.5 * (V(nz) * eye(size(D_0)) +  Z )^-1 * A^-0.5 + 1/4 * eye(size(D_0)))^0.5 * A^0.5 - 1/2 * A - D_0;
%         if ( real(trace(Q)) < Pz)
%             Zmax = Z;
%             break;
%         else
%             Zmin = U(:, nz - i + 1) * V(nz - i + 1) * U(:, nz - i + 1)';
%             v_th = V(nz - i + 1);
%         end
%     end
    
%----2----   
%     Zmin = zeros(size(D_0)); % minimum case Z is 0 (when Pz becomes large enough for PD Q')
%     Zmax = N^-1 -lambda_th * eye(size(D_0)); %maximum case Z is N^-1 (when Pz becomes to 0)
%     for i = 1 : length(V)
%         dV = lambda_th - V(i); % difference between the current eigenvalue and lambda
%         inc = U(:, i) * dV * U(:, i)'; % decrease item (matrix) for Z_min
%         Z = Zmin + inc;
%         Q = A^0.5 *( A^-0.5 * (V(i) * eye(size(D_0)) +  Z )^-1 * A^-0.5 + 1/4 * eye(size(D_0)))^0.5 * A^0.5 - 1/2 * A - D_0;
%         if ( real(trace(Q)) > Pz)
%             Zmin = Z;
%             break;
%         else
%             Zmax = Z;
%         end
%     end
    
%     % find Z(Pz) by searching for \rho, where Z(Pz) = \rho * Zmin + (1 - \rho) * Z  
%     tol1=1e-5; % tolerance
%     tol2=1e-5;
%     a = 0; % min rho
%     b = 1; % max rho
%     while b - a > tol1
%         c = (a + b) / 2;
%         Z = c * Zmin + (1 - c) * Zmax;
%         Q = A^0.5 *( A^-0.5 * (lambda_th * eye(size(D_0)) +  Z )^-1 * A^-0.5 + 1/4 * eye(size(D_0)))^0.5 * A^0.5 - 1/2 * A - D_0;
%         if abs( Pz - real(trace(Q)) ) <= tol2
%             rho = c;
%             break
%         elseif Pz - real(trace(Q)) > tol2
%             a = c;
%         else
%             b = c;
%         end
%         rho = a;
%     end
%     Z = rho * Zmin + (1 - rho) * Zmax;
%     Q = A^0.5 *( A^-0.5 * (lambda_th * eye(size(D_0)) +  Z )^-1 * A^-0.5 + 1/4 * eye(size(D_0)))^0.5 * A^0.5 - 1/2 * A - D_0;
end

Q_dc = DC_X(Pz, A, D_0);

R_1_jammedpart = real(log2(det(eye(size(D_0)) + A * (Q + D_0)\eye(size(D_0)))));
R_2_jammedpart = real(log2(det(eye(size(D_0)) + A * (Q_dc + D_0)\eye((size(D_0))))));
dif = R_1_jammedpart - R_2_jammedpart;
