function [cc]=crb(A_t, A_r, Theta, W, SNR, T, lamda_r, lamda_t, M, N) 
%computes the crb for two sources
                                             % Total number of transmitting antennas
E = M;
L = length(Theta);                                  % Number of targets
dA_t = (1i*2*pi*lamda_t*(0:M-1)'*cos(Theta)).*A_t;
dA_r = (1i*2*pi*lamda_r'*cos(Theta)).*A_r;
%
%------------------------------------------------------------------
                                  % corresponds to Transmit beamspace using spheroidal sequences
%W = W_Tx_sub;                                   % corresponds to Transmit beamspace using two fully-overlapped subarrays
%W = [[1; zeros(M-1, 1)] [0; 1; zeros(M-2, 1)]]; % MIMO using two Tx antennas spaced Lamda/2
%W = [ [1; zeros(M-1, 1)] [zeros(M-1, 1);1] ];   % MIMO using two Tx antennas spaced Lamda/2
%W = eye(M);                                     % Corresponds to traditional MIMO radar
NormalizFactor = sqrt(E/trace(W*W'));
W = NormalizFactor*W;

K = size(W,2);              % Number of waveforms used, i.e. size of virtual array is K*N.
V = [];                     % Virtual array steering matrix
D = [];                     % Derivative of virtual array steering matrix
for ii = 1:L
    V = [V kron(W'*A_t(:,ii), A_r(:,ii))];
    D = [D (kron(W'*dA_t(:,ii), A_r(:,ii)) +  kron(W'*A_t(:,ii), dA_r(:,ii)) )];
end
V_orth = eye(K*N)-V*inv(V'*V)*V';
%-----------------------------------------------------------------
sigma = 1; % noise power
for k = 1: length(SNR);
    powS = 10^(SNR(k)/10);
    P = powS*eye(L);
    %
    R = V*P*V' + sigma*eye(K*N);
    H = D'*V_orth*D;
    G = P*(V'*inv(R)*V)*P;
    C = (sigma/(2*T))*inv(real(H.*G.'));
    cc(k) = sqrt(sum(diag(C))/L)*180/pi;
    
end
cc = cc(:)
end
