%This file compares the performance of the proposed method to that of SDD
%and conventional MIMO in terms of the ability to resolve two closely
%located targets. Its function is identical to Performance_Comparison.m
clc
clear
tic
M_t = 10;                                              % Total number of transmitting antennas
M_r = 10;                                              % Total number of receiving antennas
d_t = 0.5;                                             % transmitter spacings in wavelength
Theta = [40 41];
Theta_rad = Theta*pi/180;                               % Directions of targets to the broadside of the array
L_tar = length(Theta);
A_t = exp(j*d_t*2*pi*(0:M_t-1)'*sin(Theta_rad));        % Uplink steering vectors
d_r=[ 0; 0.088751705948312; 0.521021743058417; 1.250017937612549 ; 1.824886967042458; 3.175813189953003;
    3.692431862918508; 7.318498475733820; 8.042845778221803; 9.000000000000000]';

A_r = exp(j*pi*d_r'*sin(Theta_rad));                     % Downlink steering vectors; Tx and Rx are assumed to be close to each other
T = 50;                                                  % number of radar pulses (slow-time)
t1=(-40)/180*pi;
t2=(-20)/180*pi;
t3=(30)/180*pi;
t4=(50)/180*pi;

% ---------- Orthogonal waveforms ------%
N = 1024;                                               % number of smaples within one radar pulse (fast-time)
phi = [];
for kk = 1:M_t
    phi = [phi; (1/sqrt(N))*exp(j*2*pi*(kk/N)*(0:N-1))];
end
phi_beam = phi(1:4,:);
s_mimo = A_t.'*phi;

%----------- Load Beamspace Matrices----------%
load W_n_opt;
MATTT=W_n_opt;
C = trace(MATTT'*MATTT);
MATTT = (MATTT/sqrt(C))*sqrt(10);
A_beam = (MATTT)'*A_t
s_beam = sqrt(1)*A_beam.'*phi_beam;
load X_sub_opt;
MATTT1 = X_sub_opt;
C1 = trace(MATTT1'*MATTT1);
MATTT1 = (MATTT1/sqrt(C1))*sqrt(10);
A_beam_so = (MATTT1)'*A_t
s_beam_so = sqrt(1)*A_beam_so.'*phi_beam;
P_noise = 1;
SNR = [-30:3:30];
MSE = zeros(length(SNR), 3);
montcarlo = 500;
resolve_beam = zeros(length(SNR),1);
resolve_mimo = zeros(length(SNR),1);
resolve_beam_so = zeros(length(SNR),1);
for itr = 1:montcarlo, itr
    %-----------Generate Noise and Radar Coefficient--------------%
    Beta = sqrt(0.5)*(randn(L_tar,T)+1i*randn(L_tar,T));
    Z_new = [];
    Z_mimo = [];
    Z_new_so = [];
    for n_pulse = 1:T;
        z = sqrt(P_noise/2)*(randn(M_r,N)+1i*randn(M_r,N));
        z3 = z*conj(phi_beam.');% z2 = sqrt(1/var(z2))*z2;
        Z_new_so = [Z_new reshape(z3,4*M_r,1)];
        z2 = z*conj(phi_beam.');% z2 = sqrt(1/var(z2))*z2;
        Z_new = [Z_new reshape(z2,4*M_r,1)];
        z1 = z*conj(phi.');% z1 = sqrt(1/var(z1))*z1;
        Z_mimo = [Z_mimo reshape(z1,M_t*M_r,1)];
    end
    Var_new_so = diag(1./sqrt(var(Z_new_so.')));
    Z_new_so = Var_new_so*Z_new_so;
    Var_new = diag(1./sqrt(var(Z_new.')));
    Z_new = Var_new*Z_new;
    Var_mimo = diag(1./sqrt(var(Z_mimo.')));
    Z_mimo = Var_mimo*Z_mimo;

    for snr = 1:length(SNR)
        P_tar = 10^(SNR(snr)/10);
        Beta_tar = sqrt(P_tar/2)*Beta;
        x_beam_so = [];
        x_beam = [];
        x_mimo = [];
        for n_pulse = 1:T;
            % compute signals observed at targets
            s_tar_beam = diag(Beta_tar(:,n_pulse))*s_beam;
            x_tar_beam = A_r*s_tar_beam;
            s_tar_beam_so = diag(Beta_tar(:,n_pulse))*s_beam_so;
            x_tar_beam_so = A_r*s_tar_beam_so;
            s_tar_mimo = diag(Beta_tar(:,n_pulse))*s_mimo;
            x_tar_mimo = A_r*s_tar_mimo;
            x_beam = [x_beam reshape(x_tar_beam*conj(phi_beam.'), 4*M_r, 1)];
            x_mimo = [x_mimo reshape(x_tar_mimo*conj(phi.'), M_t*M_r, 1)];
            x_beam_so = [x_beam_so reshape(x_tar_beam_so*conj(phi_beam.'), 4*M_r, 1)];
        end
        x_mimo = x_mimo + Z_mimo;
        R_mimo = (1/T)*x_mimo*x_mimo'; %cross-correlation matrix for MIMO

        x_beam = x_beam +Z_new;
        [mm,nn]=size(x_beam);
        y_beam1=x_beam(1:10,:)+x_beam(11:20,:);
        y_beam2=x_beam(21:30,:)+ x_beam(31:40,:);
        y_beam=[y_beam1;y_beam2];
        R_beam = (1/T)*y_beam*y_beam'; %cross-correlation matrix for Proposed method
        
        x_beam_so = x_beam_so + Z_new_so;
        [mm,nn]=size(x_beam_so);
        y_beam_so_1=x_beam_so(1:10,:)+x_beam_so(11:20,:);
        y_beam_so_2=x_beam_so(21:30,:)+ x_beam_so(31:40,:);
        y_beam_so=[y_beam_so_1;y_beam_so_2];
        R_beam_so = (1/T)*y_beam_so*y_beam_so'; %cross-correlation matrix for SDD
        
        %discon_find finds a discontinuity in the phase profile
        %corresponding to a given beamspace matrix if it exists. unwrapkon.m, which is
        %called by angle_extract uses this information to either unwrap the
        %phase profile or not. The returned phase profile is then used in
        %comparison with the phase argument from ESPRIT to provide the DOA
        %estimates
        [TTT1,min1] = discon_find(t1,t2,MATTT);
        [TTT2,min2] = discon_find(t3,t4,MATTT);
        
        [TTTT1,min_so_1] = discon_find(t1,t2,MATTT1);
        [TTTT2,min_so_2] = discon_find(t3,t4,MATTT1);

        psi = LS_ESPRIT(R_beam, L_tar, 0); %ESPRIT
        %target could be in 2 possible places (left, or right side of the sector). 
        %We have two targets, we divide our sector in two, therefore there are 4 possible target
        %arrangements which will be parsed using MUSIC.
        angles1(1)=angle_extract(angle(psi(1)),t1,t2,10,10,MATTT,TTT1,min1);
        angles1(2)=angle_extract(angle(psi(1)),t3,t4,10,10,MATTT,TTT2,min2);

        angles2(1)=angle_extract(angle(psi(2)),t3,t4,10,10,MATTT,TTT2,min2);
        angles2(2)=angle_extract(angle(psi(2)),t1,t2,10,10,MATTT,TTT1,min1);
        
        psi = LS_ESPRIT(R_beam_so, L_tar, 0);
        angles_so_1(1)=angle_extract(angle(psi(1)),t1,t2,10,10,MATTT1,TTTT1,min_so_1);
        angles_so_1(2)=angle_extract(angle(psi(1)),t3,t4,10,10,MATTT1,TTTT2,min_so_2);
        
        psi = LS_ESPRIT(R_beam_so, L_tar, 0);
        angles_so_2(1)=angle_extract(angle(psi(2)),t1,t2,10,10,MATTT1,TTTT1,min_so_1);
        angles_so_2(2)=angle_extract(angle(psi(2)),t3,t4,10,10,MATTT1,TTTT2,min_so_2);
        
        %---------------------Parsing Target Locations using MUSIC-------%
        [A,B]=eig(R_mimo);
        G=A(:,3:100);
        A_T = exp(j*d_t*2*pi*(0:M_t-1)'*sin(angles1(1)/180*pi));        % Uplink steering vectors
        A_R = exp(j*pi*d_r'*sin(angles1(1)/180*pi));
        v=kron(A_T,A_R);
        S1= real(v'*G*G'*v);

        A_T = exp(j*d_t*2*pi*(0:M_t-1)'*sin(angles1(2)/180*pi));        % Uplink steering vectors
        A_R = exp(j*pi*d_r'*sin(angles1(2)/180*pi));
        v=kron(A_T,A_R);
        S2= real(v'*G*G'*v);
        
        if S1 <= S2
                    angles(1) = angles1(1);
                else
                    angles(1) = angles1(2);
        end


        A_T = exp(j*d_t*2*pi*(0:M_t-1)'*sin(angles2(1)/180*pi));        % Uplink steering vectors
        A_R = exp(j*pi*d_r'*sin(angles2(1)/180*pi));
        v = kron(A_T,A_R);
        S1 = real(v'*G*G'*v);

        A_T = exp(j*d_t*2*pi*(0:M_t-1)'*sin(angles2(2)/180*pi));        % Uplink steering vectors
        A_R = exp(j*pi*d_r'*sin(angles2(2)/180*pi));
        v=kron(A_T,A_R);
        S2= real(v'*G*G'*v);
        
                if S1 <= S2
                    angles(2) = angles2(1);
                else
                    angles(2) = angles2(2);
                end

        [A_cvx,B_cvx]=eig(R_mimo);
        G=A_cvx(:,3:100);
        A_T = exp(j*d_t*2*pi*(0:M_t-1)'*sin(angles_so_1(1)/180*pi));        % Uplink steering vectors
        A_R = exp(j*pi*d_r'*sin(angles_so_1(1)/180*pi));
        v = kron(A_T,A_R);
        S1 = real(v'*G*G'*v);


        A_T = exp(j*d_t*2*pi*(0:M_t-1)'*sin(angles_so_1(2)/180*pi));        % Uplink steering vectors
        A_R = exp(j*pi*d_r'*sin(angles_so_1(2)/180*pi));
        v = kron(A_T,A_R);
        S2 = real(v'*G*G'*v);
        
                if S1 <= S2
                    angles_so(1) = angles_so_1(1);
                else
                    angles_so(1) = angles_so_1(2);
                end


        A_T = exp(j*d_t*2*pi*(0:M_t-1)'*sin(angles_so_2(1)/180*pi));        % Uplink steering vectors
        A_R = exp(j*pi*d_r'*sin(angles_so_2(1)/180*pi));
        v = kron(A_T,A_R);
        S1 = real(v'*G*G'*v);

        A_T = exp(j*d_t*2*pi*(0:M_t-1)'*sin(angles_so_2(2)/180*pi));        % Uplink steering vectors
        A_R = exp(j*pi*d_r'*sin(angles_so_2(2)/180*pi));
        v = kron(A_T,A_R);
        S2= real(v'*G*G'*v);
        
                if S1 <= S2
                    angles_so(2) = angles_so_2(1);
                else
                    angles_so(2) = angles_so_2(2);
                end
                
        %--------------DOA Estimates and Resolution Calc------------------%       
        DOA_beam = sort(angles);
        MSE(snr, 1) = MSE(snr, 1) + mean((Theta(:) - DOA_beam(:)).^2);
        %
        psi = LS_ESPRIT(R_mimo, L_tar, 1);
        DOA = asin((-1/(d_t*2*pi))*angle(psi))*180/pi;
        DOA_mimo = sort(DOA);
        MSE(snr, 2) = MSE(snr, 2) + mean((Theta(:) - DOA_mimo(:)).^2);
        
        DOA_beam_so = sort(angles_so);
        MSE(snr, 3) = MSE(snr, 3) + mean((Theta(:) - DOA_beam_so(:)).^2);
        disp([DOA_beam DOA_mimo' DOA_beam_so ])
        
        
        d_theta1 = abs(DOA_beam(1) - Theta(1));
        d_theta2 = abs(DOA_beam(2) - Theta(2)) ;

        if (d_theta1 <= abs(Theta(1) - Theta(2))/2) && (d_theta2 <= abs(Theta(1) - Theta(2))/2)
            resolve_beam(snr) = resolve_beam(snr) + 1;
        end

        d_theta3 = abs(DOA_mimo(1) - Theta(1));
        d_theta4 = abs(DOA_mimo(2) - Theta(2)) ;

        if (d_theta3 <= abs(Theta(1) - Theta(2))/2) && (d_theta4 <= abs(Theta(1) - Theta(2))/2)
            resolve_mimo(snr) = resolve_mimo(snr) + 1;
        end
        
        d_theta5 = abs(DOA_beam_so(1) - Theta(1));
        d_theta6 = abs(DOA_beam_so(2) - Theta(2)) ;
        
        if (d_theta5 <= abs(Theta(1) - Theta(2))/2) && (d_theta6 <= abs(Theta(1) - Theta(2))/2)
            resolve_beam_so(snr) = resolve_beam_so(snr) + 1;
        end
    end
end
p_resolve_beam = resolve_beam./montcarlo;
p_resolve_mimo = resolve_mimo./montcarlo;
p_resolve_beam_so = resolve_beam_so./montcarlo;

figure
hold on
axis([-30 30 0 1.5])
xlabel('SNR of Received Signal')
ylabel('Probability of Resolution of Two Closely Located Targets')
plot(SNR,p_resolve_mimo,'-sqm',SNR, p_resolve_beam_so ,'*-r',SNR, p_resolve_beam,'o--b','LineWidth',2,'MarkerSize',10)
grid
hold on
xlabel('SNR (dB)')
ylabel('RMSE (Degrees)')
legend('Conventional MIMO radar', 'SDD', 'Best Achievable Tx Beamspace')

%save Example2_Workspace_Resolution.mat