%This file plots Figure 2 in the journal paper

clear
clc
load W_n_opt;
load X_sub_opt;
load X_pre;
N = 10;

theta =-pi/2:.01:pi/2;

C = trace(X_sub_opt'*X_sub_opt);
X_sub_opt = (X_sub_opt/sqrt(C))*sqrt(10);

C = trace(X);
X = X/C*10;

for i = 1:length(theta)
    Beam_opt(i) = trace(matA(theta(i),N)*W_n_opt*W_n_opt');
    Beam_sub_opt(i) = trace(matA(theta(i),N)*X_sub_opt*X_sub_opt');
    Beam_pre_rand(i) = trace(matA(theta(i),N)*X);
    Beam_mimo(i) = trace(matA(theta(i),N)*eye(N));
end

counter = 0;

for i = 1:9:length(theta)
    counter = counter + 1;
    marker_opt(counter) = Beam_opt(i);
    marker_sub_opt(counter) = Beam_sub_opt(i);
    marker_pre_rand(counter) = Beam_pre_rand(i);
    marker_mimo(counter) = Beam_mimo(i);
    theta_marker(counter) = theta(i);
end

theta = theta/pi*180;
theta_marker = theta_marker/pi*180;

odd = 1:2:length(marker_opt);
even = 2:2:length(marker_opt);

theta_odd = theta_marker(odd);
theta_even = theta_marker(even);

marker_opt_odd = marker_opt(odd);
marker_pre_rand_even = marker_pre_rand(even);
marker_sub_opt_odd = marker_sub_opt(odd);
marker_mimo_odd = marker_mimo(odd);

hFig = figure(1)
set(hFig,'Position',[500 100 500 500])
axis([-90 90 -15 25])
grid
hold on
xlabel('\theta (dB)')
ylabel('Transmit Power (dB)')
plot(theta_marker,marker_mimo,'m-',theta_marker,10*log10(marker_opt),'b-o'...
    ,theta_marker,10*log10(marker_sub_opt),'r-*',theta_marker,10*log10(marker_pre_rand),'k-v','markers',10,'LineWidth',2)
plot(theta_marker,marker_mimo,'w-',theta_marker,10*log10(marker_opt),'w-o'...
    ,theta_marker,10*log10(marker_sub_opt),'w-*',theta_marker,10*log10(marker_pre_rand),'w-v','markers',10,'LineWidth',2)
plot(theta_odd,10*log10(marker_opt_odd),'bo'...
    ,theta_odd,10*log10(marker_sub_opt_odd),'r*',theta_even,10*log10(marker_pre_rand_even),'kv','markers',10,'LineWidth',2)
legend('Conventional MIMO radar', 'Best Achievable Tx Beamspace', 'SDD','Beampattern Before Randomization')
hold on
plot(theta,10*log10(abs(Beam_opt)),'b-',theta,10*log10(Beam_sub_opt),'r-'...
    ,theta,10*log10(Beam_pre_rand),'k-',theta,10*log10(Beam_mimo),'m-','LineWidth',2)
