clear
clc

M_t = 10;                                              
M_r = 10;

d_t = 0.5;

Theta = [-33 41];
Theta_rad = Theta*pi/180;                               % Directions of targets to the broadside of the array
L_tar = length(Theta);
A_t = exp(j*d_t*2*pi*(0:M_t-1)'*sin(Theta_rad));        % Uplink steering vectors
d_r=[ 0; 0.088751705948312; 0.521021743058417; 1.250017937612549 ; 1.824886967042458; 3.175813189953003;
    3.692431862918508; 7.318498475733820; 8.042845778221803; 9.000000000000000]';

load Xopt_4
W_half = WW;
load Xopt_8
W_full = WW;

SNR = [-30:3:30];

A_r = exp(j*pi*d_r'*sin(Theta_rad));                     
T = 50;

CRB_full = crb(A_t, A_r, Theta_rad, W_full, SNR, T, d_r, d_t, M_t, M_r);
CRB_half = crb(A_t, A_r, Theta_rad, W_half, SNR, T, d_r, d_t, M_t, M_r);

figure(1)
semilogy(SNR,CRB_full,'r--',SNR,CRB_half,'b-')

theta = -pi/2:0.01:pi/2;
Power_full = trace(W_full*W_full');
W_full = W_full/sqrt(Power_full)*sqrt(M_t);

Power_half = trace(W_half*W_half');
W_half = W_half/sqrt(Power_half)*sqrt(M_t);

for i = 1:length(theta)
    for l = 1:M_t;
    a(l,1)=exp(1i*pi*sin(theta(i))*(l-1));
    end  
    Beam_full(i) = a'*W_full*W_full'*a;
    Beam_half(i) = a'*W_half*W_half'*a;    
end

x = trace(W_full*W_full')
y = trace(W_half*W_half')

figure(2)
plot(theta,10*log10(Beam_full),'b-',theta,10*log10(Beam_half),'r--')
