function out=angle_extract(vals,tet1,tet2,M_t,M_r,W,TTT,min)
d_t = 0.5;                                             % transmitter spacings in wavelength
out=[];
l=length(vals);


for kk=1:l
    val=vals(kk);
    val=unwrapkon(val,TTT);
    teta1=tet1;
    teta2=tet2;
    A_t1 = exp(j*d_t*2*pi*(0:M_t-1)'*sin(teta1));        % Uplink steering vectors
    %     A_beam1 = W'*A_t1;
    %     c1=angle(A_beam1(1))-angle(A_beam1(2)) ;
    y1=sum(A_t1'*W(:,1:size(W,2)/2));
    y2=sum(A_t1'*W(:,size(W,2)/2+1:size(W,2)));
    c1=-angle(y1./y2);
    if c1 < min
        c1 = c1 + (abs(c1) - abs(min)) + 0.001;
    else
    c1=unwrapkon(c1,TTT);
    end

    A_t2 = exp(j*d_t*2*pi*(0:M_t-1)'*sin(teta2));        % Uplink steering vectors
    %     A_beam2 = W'*A_t2;
    %     c2=angle(A_beam2(1))-angle(A_beam2(2)) ;
    y1=sum(A_t2'*W(:,1:size(W,2)/2));
    y2=sum(A_t2'*W(:,size(W,2)/2+1:size(W,2)));
    c2=-angle(y1./y2);
    if c2 < min
        c2 = c2 + (abs(c2) - abs(min)) + 0.001;
    else
    c2=unwrapkon(c2,TTT);
    end

    e=[teta1 teta2]/pi*180;
    d=[c1 c2];
    [sorted ind]=sort(d);
    if val <= sorted(1)
        teta_f=e(ind(1));
    end

    if val >= sorted(2)
        teta_f=e(ind(2));
    end

    if val > sorted(1) && val < sorted(2)

        while ( teta2 - teta1 > .0000001)
            A_t1 = exp(j*d_t*2*pi*(0:M_t-1)'*sin(teta1));        % Uplink steering vectors
%             A_beam1 = W'*A_t1;
%             c1=angle(A_beam1(1))-angle(A_beam1(2)) ;
            y1=sum(A_t1'*W(:,1:size(W,2)/2));
            y2=sum(A_t1'*W(:,size(W,2)/2+1:size(W,2)));
            c1=-angle(y1./y2);
            if c1 < min
            c1 = c1 + (abs(c1) - abs(min)) + 0.001;
            c1 = c1 - val;
            else
            c1=unwrapkon(c1,TTT)- val;
            end
            

            A_t2 = exp(j*d_t*2*pi*(0:M_t-1)'*sin(teta2));        % Uplink steering vectors
%             A_beam2 = W'*A_t2;
%             c2=angle(A_beam2(1))-angle(A_beam2(2)) ;
            y1=sum(A_t2'*W(:,1:size(W,2)/2));
            y2=sum(A_t2'*W(:,size(W,2)/2+1:size(W,2)));
            c2=-angle(y1./y2);
            if c2 < min
            c2 = c2 + (abs(c2) - abs(min)) + 0.001;
            c2 = c2 - val;
            else
            c2=unwrapkon(c2,TTT)- val;
            end

            teta_md=(teta1+teta2)/2;
            A_t_md = exp(j*d_t*2*pi*(0:M_t-1)'*sin(teta_md));        % Uplink steering vectors
            y1=sum(A_t_md'*W(:,1:size(W,2)/2));
            y2=sum(A_t_md'*W(:,size(W,2)/2+1:size(W,2)));
            c_md=-angle(y1./y2);
            if c_md < min
            c_md = c_md + (abs(c_md) - abs(min)) + 0.001;
            c_md = c_md - val;
            else
            c_md=unwrapkon(c_md,TTT)- val;
            end
            
            if c1*c_md < 0
                teta2= teta_md;
            end

            if c2*c_md < 0
                teta1= teta_md;
            end

            if c_md == 0
                teta1=teta_md;
                teta2=teta_md;
            end

        end
        teta_f=teta1/pi*180;
    end
    out=[out;teta_f];
end