function [W1 W2] = TxEnrgFocusWeights(M, K, d, Sector, TransWidth, delta);

NgridPass = 151;
NgridStop = 50;
TetaPass = linspace(Sector(1), Sector(2), NgridPass)*pi/180;
Apass = exp(j*d*2*pi*(0:M-1)'*sin(TetaPass));
Adesired = exp(j*d*2*pi*([1 4])'*sin(TetaPass));

TetaStop = [linspace(-90, Sector(1)-TransWidth, NgridStop)...
            linspace(Sector(2)+TransWidth, 90, NgridStop)]*pi/180;
Astop = exp(j*d*2*pi*(0:M-1)'*sin(TetaStop));      

% Spheroidal sequences method
[U, D, V] = svd(Apass*Apass');
W1 = U(:, 1:K)

% Convex optimization based design
cvx_begin 
    variable W(M, K) complex;
    variable tau
    minimize tau
    subject to
    for ii = 1:NgridPass
        ii
        max( abs( W'*Apass(:, ii) - Adesired( :, ii)) ) <= tau;
    end
    %
    for jj = 1:2*NgridStop
        jj
        norm(W'*Astop(:, jj)) <= 0.38;
    end
cvx_end
W2 = W;

%--------- Compute transformation gain pattern -------------------
th = linspace(-pi/2,pi/2,361);L_th = length(th);
sv = exp(-j*d*2*pi * (0:M-1)'* sin(th));
for i= 1:L_th;
    gain1(i) = 10*log10(norm(sv(:,i)'*W1)^2);
    gain2(i) = 10*log10(norm(sv(:,i)'*W2)^2);
end
gain1 = gain1 - max(gain1);
gain2 = gain2 - max(gain2);
figure
plot(th*180/pi, gain1,'-.m', th*180/pi, gain2,'b');grid
axis([-90.1 90.1 -20.1 5.1])
xlabel('ANGLE (DEGREES)')
ylabel('Normalized transmit beampattern (dB)')
legend('Spheroidal sequences','Convex optimization design')
