%This file generates the beamspace matrices for Example 3 of the Journal
%paper. Figures generated in this file are meant as quick checks. Figure 5
%in the journal is produced by Beampattern_Plot.m
clc
clear
N=10;                         % Number of the Antennas
M=120;                        % Number of the directions
KK=1;
Pt=10;                         % Transmit Power of each Antenna
teta = linspace(-pi/2,pi/2,M);

Pd=zeros(M,1);% Desired pattern
%Pd2=ones(M+1,1)*(0);
shift=0;
counter = 0;
t1=(-15+shift)/180*pi;                   % x/180*M should be a integer numberv
i1=t1/pi*M+M/2+1;               % for the case of M=120, x=3*k
t2=(0+shift)/180*pi;
i2=t2/pi*M+M/2+1;

eta = 10/180*pi;
index1 = find(teta <= t2 & teta >= t1);

Pd(index1) = 20;

index2 = find(teta <= t1 & teta >= t1 - eta);
Pd(index2) = [];
teta(index2) = [];

t3=(0+shift)/180*pi;                   % x/180*M should be a integer numberv
i3=t3/pi*M+M/2+1;               % for the case of M=120, x=3*k
t4=(15+shift)/180*pi;
i4=t4/pi*M+M/2+1;

index3 = find(teta <= t4 & teta >= t3);

Pd(index3) = 20;

index4 = find(teta <= t4 + eta & teta >= t4);

Pd(index4) = [];
teta(index4) = [];

TT = length(Pd);




cvx_begin sdp
variable X(N,N) hermitian;
variable z
variable alpha
minimize (z)
subject to
for i=1:TT
   -trace(matA(teta(i),N)*X)-z <= -Pd(i);
    trace(matA(teta(i),N)*X)-z <= Pd(i);
end

X(1,1)+X(10,10) == Pt/10;
X(2,2)+X(9,9) == Pt/10;
X(3,3)+X(8,8) == Pt/10;
X(4,4)+X(7,7) == Pt/10;
X(5,5)+X(6,6) == Pt/10;
X  >= 0
cvx_end

% hold on
% % Plot of the Patterns
% counter=0;
% for teta1=-pi/2:.01:pi/2
%     counter=counter+1;
%     teyf(counter)=trace(matA(teta1,N)*X);
% end
% plot((-pi/2:.01:pi/2)/pi*180,10*log10(abs(teyf)),'m')
% 
%--------------------------------------------------------------------------
%--------------------------------------------------------------------------
%--------------------------------------------------------------------------
% Randomization for recovery

NumberofWaveform=4;
[u,v]=eig(X);
root_mat=u*v.^(.5);
for shomara=1:1000
    disp(shomara)
    Candidatew=[];
    for lll=1:KK
        ran_vec=randn(N,NumberofWaveform)+j*randn(N,NumberofWaveform);
        ran_vec=ran_vec./abs(ran_vec);
        Candidatetemp=root_mat*ran_vec;
        Candidatew=Candidatetemp;
    end
    for lll=1:N/2
        aaa=[Candidatew(lll,:) Candidatew(N-(lll-1),:)];
        Candidatew(lll,:)= Candidatew(lll,:)/norm(aaa)*sqrt(Pt/10);
        Candidatew(N-(lll-1),:)= Candidatew(N-(lll-1),:)/norm(aaa)*sqrt(Pt/10);
    end


    for ind1=1:TT
        temp(ind1)=abs(trace(matA(teta(ind1),N)*Candidatew*Candidatew')-Pd(ind1));
    end
    Val1=max(temp);
    if (shomara ==1)
        Val=Val1;
        Candidatefinal=Candidatew;
    else
        if ( abs(Val)- abs(Val1) > 0  )
            Val=Val1;
            Candidatefinal=Candidatew;
        end
    end
end

%--------------------------------------------------------------------------
%--------------------------------------------------------------------------
%--------------------------------------------------------------------------
% Plot of the Patterns
counter=0;
for teta1=-pi/2:.01:pi/2
    counter=counter+1;
    teyf(counter)=trace(matA(teta1,N)*X);
end

save X_pre.mat X

plot((-pi/2:.01:pi/2)/pi*180,10*log10(abs(teyf)),'b')

hold on
counter=0;
WW=[Candidatefinal conj(Candidatefinal(10:-1:1,:))];
save Xopt.mat WW

Xrot = [WW(:,1) WW(:,2)];
Xrot1 = integ(Xrot,N); %Xrot1 is matrix D in optimization over Stiefel Manifold

save Xrot1.mat Xrot1

for teta1=-pi/2:.01:pi/2
    counter=counter+1;
    teyf1(counter)=trace(matA(teta1,N)*WW*WW');
end
plot((-pi/2:.01:pi/2)/pi*180,10*log10(abs(teyf1)/2),'m--')

M_t = 10;                                              % Total number of transmitting antennas
M_r = 10;                                              % Total number of receiving antennas
K = 2;                 % Number of transmit beams
d_t = 0.5;% transmitter spacings in wavelength

PassSector = [-15 15];   % desired sector
TransWidth = 10;         % transition width, i.e., are of uncontroled beampattern.
delta = 0.001;      % parameter that controls the passband accuracey
[Wsph Wconvex] = TxEnrgFocusWeights(M_t, K, d_t, PassSector, TransWidth, delta);

save Wsph.mat Wsph

save Wconvex.mat Wconvex
