%This file compares the performance between the proposed method, method of
%[15], and traditional MIMO radar in terms of RMSE.
clc
clear
tic
M_t = 10;                                              % Total number of transmitting antennas
M_r = 10;                                              % Total number of receiving antennas
d_t = 0.5;% transmitter spacings in wavelength
shift = 0;
Theta = [-33 41];
Theta_rad = Theta*pi/180;                               % Directions of targets to the broadside of the array
L_tar = length(Theta);
A_t = exp(j*d_t*2*pi*(0:M_t-1)'*sin(Theta_rad));        % Uplink steering vectors
d_r=[ 0; 0.088751705948312; 0.521021743058417; 1.250017937612549 ; 1.824886967042458; 3.175813189953003;
    3.692431862918508; 7.318498475733820; 8.042845778221803; 9.000000000000000]';

A_r = exp(j*pi*d_r'*sin(Theta_rad));                     % Downlink steering vectors; Tx and Rx are assumed to be close to each other
T = 50;                                                  % number of radar pulses (slow-time)
t1=(-40+shift)/180*pi;
t2=(-20+shift)/180*pi;
t3=(30+shift)/180*pi;
t4=(50+shift)/180*pi;

% ---------- Orthogonal waveforms ------%
N = 1024;                                               % number of smaples within one radar pulse (fast-time)
phi = [];
for kk = 1:M_t
    phi = [phi; (1/sqrt(N))*exp(j*2*pi*(kk/N)*(0:N-1))];
end
phi_beam = phi(1:4,:);
s_mimo = A_t.'*phi;

%---------------load beamspace matrices-----------%
load Xopt;
MATTT2 = Xopt;
C = trace(MATTT2'*MATTT2);
MATTT2 = (MATTT2/sqrt(C))*sqrt(10);
load W_n_opt;

MATTT = W_n_opt;
C = trace(MATTT'*MATTT);
MATTT = (MATTT/sqrt(C))*sqrt(10);
A_beam = (MATTT)'*A_t
s_beam = sqrt(1)*A_beam.'*phi_beam;
load X_sub_opt;

MATTT1 = X_sub_opt;
C1 = trace(MATTT1'*MATTT1);
MATTT1 = (MATTT1/sqrt(C1))*sqrt(10);
A_beam_so = (MATTT1)'*A_t
s_beam_so = sqrt(1)*A_beam_so.'*phi_beam;
P_noise = 1;
SNR = [-30:3:30];
MSE = zeros(length(SNR), 3);
montcarlo = 500;
for itr = 1:montcarlo, itr
    %-------------Generation of Signal Noise-------------%
    Beta = sqrt(0.5)*(randn(L_tar,T)+1i*randn(L_tar,T));
    Z_new_so = []; %initialize noise vectors
    Z_new = [];
    Z_mimo = [];
    for n_pulse = 1:T;
        z = sqrt(P_noise/2)*(randn(M_r,N)+1i*randn(M_r,N));
        z3 = z*conj(phi_beam.');
        Z_new_so = [Z_new reshape(z3,4*M_r,1)];
        z2 = z*conj(phi_beam.');
        Z_new = [Z_new reshape(z2,4*M_r,1)];
        z1 = z*conj(phi.');
        Z_mimo = [Z_mimo reshape(z1,M_t*M_r,1)];
    end
    Var_new_so = diag(1./sqrt(var(Z_new_so.')));
    Z_new_so = Var_new_so*Z_new_so;
    Var_new = diag(1./sqrt(var(Z_new.')));
    Z_new = Var_new*Z_new;
    Var_mimo = diag(1./sqrt(var(Z_mimo.')));
    Z_mimo = Var_mimo*Z_mimo;

    for snr = 1:length(SNR)
        P_tar = 10^(SNR(snr)/10);
        Beta_tar = sqrt(P_tar)*Beta;
        x_beam_so = [];
        x_beam = [];
        x_mimo = [];
        for n_pulse = 1:T;
            % compute signals observed at targets
            s_tar_beam = diag(Beta_tar(:,n_pulse))*s_beam;%signal at target for proposed method
            x_tar_beam = A_r*s_tar_beam;%signal at receive array for proposed method
            
            s_tar_beam_so = diag(Beta_tar(:,n_pulse))*s_beam_so;%signal at target for SDD
            x_tar_beam_so = A_r*s_tar_beam_so; %signal at receive array for SDD
            
            s_tar_mimo = diag(Beta_tar(:,n_pulse))*s_mimo;%signal at target for MIMO
            x_tar_mimo = A_r*s_tar_mimo;%signal at receive array for MIMO
            
            x_beam = [x_beam reshape(x_tar_beam*conj(phi_beam.'), 4*M_r, 1)];
            x_beam_so = [x_beam_so reshape(x_tar_beam_so*conj(phi_beam.'), 4*M_r, 1)];
            x_mimo = [x_mimo reshape(x_tar_mimo*conj(phi.'), M_t*M_r, 1)];
        end
        x_mimo = x_mimo + Z_mimo;
        R_mimo = (1/T)*x_mimo*x_mimo'; %cross-correlation matrix for MIMO

        x_beam = x_beam +Z_new;
        [mm,nn]=size(x_beam);
        y_beam1=x_beam(1:10,:)+x_beam(11:20,:);
        y_beam2=x_beam(21:30,:)+ x_beam(31:40,:);
        y_beam=[y_beam1;y_beam2];
        R_beam = (1/T)*y_beam*y_beam'; %cross-correlation matrix for proposed method
        
        x_beam_so = x_beam_so + Z_new_so;
        [mm,nn]=size(x_beam_so);
        y_beam_so_1=x_beam_so(1:10,:)+x_beam_so(11:20,:);
        y_beam_so_2=x_beam_so(21:30,:)+ x_beam_so(31:40,:);
        y_beam_so=[y_beam_so_1;y_beam_so_2];
        R_beam_so = (1/T)*y_beam_so*y_beam_so'; %cross-correlation matrix for SDD
        
        
        %discon_find finds a discontinuity in the phase profile
        %corresponding to a given beamspace matrix if it exists. unwrapkon.m, which is
        %called by angle_extract uses this information to either unwrap the
        %phase profile or not. The returned phase profile is then used in
        %comparison with the phase argument from ESPRIT to provide the DOA
        %estimates
        [TTT1,min1] = discon_find(t1,t2,MATTT);
        [TTT2,min2] = discon_find(t3,t4,MATTT);
        
        [TTTT1,min_so_1] = discon_find(t1,t2,MATTT1);
        [TTTT2,min_so_2] = discon_find(t3,t4,MATTT1);

        psi = LS_ESPRIT(R_beam, L_tar, 0); %ESPRIT
        %target could be in 2 possible places (left, or right side of the sector). 
        %We have two targets, we divide our sector in two, therefore there are 4 possible target
        %arrangements which will be parsed using MUSIC.
        angles1(1)=angle_extract(angle(psi(1)),t1,t2,10,10,MATTT,TTT1,min1);
        angles1(2)=angle_extract(angle(psi(1)),t3,t4,10,10,MATTT,TTT2,min2);

        angles2(1)=angle_extract(angle(psi(2)),t1,t2,10,10,MATTT,TTT1,min1);
        angles2(2)=angle_extract(angle(psi(2)),t3,t4,10,10,MATTT,TTT2,min2);
        
        
        psi1 = LS_ESPRIT(R_beam_so, L_tar, 0);
        angles_so_1(1)=angle_extract(angle(psi1(1)),t1,t2,10,10,MATTT1,TTTT1,min_so_1);
        angles_so_1(2)=angle_extract(angle(psi1(1)),t3,t4,10,10,MATTT1,TTTT2,min_so_2);

        angles_so_2(1)=angle_extract(angle(psi1(2)),t3,t4,10,10,MATTT1,TTTT2,min_so_2);
        angles_so_2(2)=angle_extract(angle(psi1(2)),t1,t2,10,10,MATTT1,TTTT1,min_so_1);

        %----------------Parsing Target Locations using MUSIC-------------%
        [A,B]=eig(R_mimo);
        G=A(:,1:2);
        A_T = exp(j*d_t*2*pi*(0:M_t-1)'*sin(angles1(1)/180*pi));        % Uplink steering vectors
        A_R = exp(j*pi*d_r'*sin(angles1(1)/180*pi));
        v=kron(A_T,A_R);
        S1= real(v'*G*G'*v);

        A_T = exp(j*d_t*2*pi*(0:M_t-1)'*sin(angles1(2)/180*pi));        % Uplink steering vectors
        A_R = exp(j*pi*d_r'*sin(angles1(2)/180*pi));
        v=kron(A_T,A_R);
        S2= real(v'*G*G'*v);

        A_T = exp(j*d_t*2*pi*(0:M_t-1)'*sin(angles2(1)/180*pi));       % Uplink steering vectors
        A_R = exp(j*pi*d_r'*sin(angles2(1)/180*pi));
        v = kron(A_T,A_R);
        S3 = real(v'*G*G'*v);

        A_T = exp(j*d_t*2*pi*(0:M_t-1)'*sin(angles2(2)/180*pi));        % Uplink steering vectors
        A_R = exp(j*pi*d_r'*sin(angles2(2)/180*pi));
        v=kron(A_T,A_R);
        S4= real(v'*G*G'*v);
        
        S = [S1+S3, S1+S4, S2+S3, S2+S4];
        
        [val, I] = max(S);
        
        switch I
            case 1
                angles = [angles1(1) angles2(1)];
            case 2
                angles = [angles1(1) angles2(2)];
            case 3
                angles = [angles1(2) angles2(1)];
            case 4
                angles = [angles1(2) angles2(2)];
        end

        [A,B]=eig(R_mimo);
        G=A(:,1:2);
        A_T = exp(j*d_t*2*pi*(0:M_t-1)'*sin(angles_so_1(1)/180*pi));        % Uplink steering vectors
        A_R = exp(j*pi*d_r'*sin(angles_so_1(1)/180*pi));
        v=kron(A_T,A_R);
        S1= real(v'*G*G'*v);

        A_T = exp(j*d_t*2*pi*(0:M_t-1)'*sin(angles_so_1(2)/180*pi));        % Uplink steering vectors
        A_R = exp(j*pi*d_r'*sin(angles_so_1(2)/180*pi));
        v=kron(A_T,A_R);
        S2= real(v'*G*G'*v);

        A_T = exp(j*d_t*2*pi*(0:M_t-1)'*sin(angles_so_2(1)/180*pi));       % Uplink steering vectors
        A_R = exp(j*pi*d_r'*sin(angles_so_2(1)/180*pi));
        v = kron(A_T,A_R);
        S3 = real(v'*G*G'*v);

        A_T = exp(j*d_t*2*pi*(0:M_t-1)'*sin(angles_so_2(2)/180*pi));        % Uplink steering vectors
        A_R = exp(j*pi*d_r'*sin(angles_so_2(2)/180*pi));
        v=kron(A_T,A_R);
        S4= real(v'*G*G'*v);
        
        S = [S1+S3, S1+S4, S2+S3, S2+S4];
        
        [val, I] = max(S);
        
        switch I
            case 1
                angles_so = [angles_so_1(1) angles_so_2(1)];
            case 2
                angles_so = [angles_so_1(1) angles_so_2(2)];
            case 3
                angles_so = [angles_so_1(2) angles_so_2(1)];
            case 4
                angles_so = [angles_so_1(2) angles_so_2(2)];
        end
        
                
%       %--------------Display DOA Estimates and RMSE calc--------------%
        DOA_beam = sort(angles);
        MSE(snr, 1) = MSE(snr, 1) + mean((Theta(:) - DOA_beam(:)).^2);
        %
        psi = LS_ESPRIT(R_mimo, L_tar, 1);
        DOA = asin((-1/(d_t*2*pi))*angle(psi))*180/pi;
        DOA_mimo = sort(DOA);
        
        MSE(snr, 2) = MSE(snr, 2) + mean((Theta(:) - DOA_mimo(:)).^2);
        
        DOA_beam_so = sort(angles_so);
        MSE(snr, 3) = MSE(snr, 3) + mean((Theta(:) - DOA_beam_so(:)).^2);
        
        disp([DOA_beam DOA_mimo' DOA_beam_so])
    end
end
CM = MATTT;
CM_so = MATTT1;
crb_beam = crb(A_t, A_r, Theta_rad, CM, SNR, T, d_r, d_t, M_t, M_r)
crb_mimo = crb(A_t, A_r, Theta_rad, eye(M_t), SNR, T, d_r, d_t, M_t, M_r)
crb_beam_so = crb(A_t, A_r, Theta_rad, CM_so, SNR, T, d_r, d_t, M_t, M_r)
crb_beam_nonuni = crb(A_t, A_r, Theta_rad, MATTT2, SNR, T, d_r, d_t, M_t, M_r)
SNR, RMSE = sqrt(MSE/montcarlo)

hFig = figure(1)
axis square
semilogy(SNR,RMSE(:,2),'ms-', SNR,RMSE(:,3),'rv-', SNR,RMSE(:,1),'bo-','LineWidth',2,'MarkerSize',10)
grid
hold on
xlabel('SNR (dB)')
ylabel('RMSE (Degrees)')
legend('Traditional MIMO Radar', 'SDD', 'Best Achievable Tx Beamspace')

%save Example2_Workspace_RMSE.mat