function out=angle_extract(vals,tet1,tet2,M_t,M_r,W,tresh)

d_t = 0.5;                                             % transmitter spacings in wavelength
out=[];
l=length(vals);
for kk=1:l
    val=vals(kk);
    val=unwrapkon(val,tresh);
    teta1=tet1;
    teta2=tet2;
    A_t1 = exp(j*d_t*2*pi*(0:M_t-1)'*sin(teta1));        % Uplink steering vectors
    A_beam1 = W.'*A_t1;
    c1=angle(A_beam1(1))-angle(A_beam1(2)) ;
    c1=unwrapkon(c1,tresh);

    
    A_t2 = exp(j*d_t*2*pi*(0:M_t-1)'*sin(teta2));        % Uplink steering vectors
    A_beam2 = W.'*A_t2;
    c2=angle(A_beam2(1))-angle(A_beam2(2)) ;
    c2=unwrapkon(c2,tresh);
    
    e=[teta1 teta2]/pi*180;
    d=[c1 c2];
    [sorted ind]=sort(d);
    if val <= sorted(1)
        teta_f=e(ind(1));
    end

    if val >= sorted(2)
        teta_f=e(ind(2));
    end

    if val > sorted(1) && val < sorted(2)

        while ( teta2 - teta1 > .000001)
            A_t1 = exp(j*d_t*2*pi*(0:M_t-1)'*sin(teta1));        % Uplink steering vectors
            A_beam1 = W.'*A_t1;
            c1=angle(A_beam1(1))-angle(A_beam1(2)) ;
            c1=unwrapkon(c1,tresh)- val;
            
            A_t2 = exp(j*d_t*2*pi*(0:M_t-1)'*sin(teta2));        % Uplink steering vectors
            A_beam2 = W.'*A_t2;
            c2=angle(A_beam2(1))-angle(A_beam2(2)) ;
           c2=unwrapkon(c2,tresh)- val;
 
            teta_md=(teta1+teta2)/2;
            A_t_md = exp(j*d_t*2*pi*(0:M_t-1)'*sin(teta_md));        % Uplink steering vectors
            A_beam_md = W.'*A_t_md;
            c_md=angle(A_beam_md(1))-angle(A_beam_md(2)) ;
            c_md=unwrapkon(c_md,tresh)- val;
            if c1*c_md < 0
                teta2= teta_md;
            end

            if c2*c_md < 0
                teta1= teta_md;
            end

            if c_md == 0
                teta1=teta_md;
                teta2=teta_md;
            end

        end
        teta_f=teta1/pi*180;
    end
    out=[out;teta_f];
end