% This function computes DOAs using LS ESPRIT
% If overlap == 0, then the two subarrays are not overlapped
% if overlap == 1, then full overlap is assumed
function [angles] = LS_ESPRIT(R, L, d, overlap);
% L is the number of sources
% d is the separation between subarrays (i.e., subarray displacement)
% if overlap == 0, then M should be even
M = size(R, 1);
N_of_ant=sqrt(M);
[U,D,V] = svd(R);
if overlap == 0
    E1 = U(1:M/2, 1:L);
    E2 = U(M/2+1:M, 1:L);
else
    E1 = U(1:(N_of_ant-1)*N_of_ant, 1:L);
    E2 = U(N_of_ant+1:N_of_ant*N_of_ant, 1:L);
end
psi = inv(E2'*E2)*E2'*E1;
angles = eig(psi);

