function [Usp,Ucp,cpNumUser,spNumUser]  = hybridParameterOptimization(numCell,numUser,channelParameter,coherenceTime,rhoP,rhoD,ulCost,dlCost)

betaVal             = channelParameter.betaVal;
Usp                 = zeros(numCell , numUser);
Ucp                 = ones(numCell,numUser);

for nn = 1:numCell*numUser
    
    tVal           = sum(Ucp,2);
    pilotLength    = max(tVal);
    
    costCp = hybridCostFunctionCP(betaVal,Ucp,numCell,numUser,ulCost,dlCost);
    costSp = hybridCostFunctionSP(betaVal,Usp,numCell,numUser,coherenceTime-pilotLength,rhoP,rhoD,ulCost,dlCost);
    totalCost = sum(sum(costCp) + sum(costSp));
    [tVal,idxUser] = max(costCp(1:7,:),[],2);
    [~,idxCell]    = max(tVal);
    idxUser        = idxUser(idxCell);
    UspPrime       = Usp;
    UspPrime(idxCell,idxUser) = 1;
    UcpPrime       = ones(size(UspPrime)) - UspPrime;
    
    tVal                = sum(Ucp,2);
    pilotLengthPrime    = max(tVal);
    costCpPrime         = hybridCostFunctionCP(betaVal,UcpPrime,numCell,numUser,ulCost,dlCost);
    costSpPrime         = hybridCostFunctionSP(betaVal,UspPrime,numCell,numUser,coherenceTime-pilotLengthPrime,rhoP,rhoD,ulCost,dlCost);
    
    totalCostPrime = sum(sum(costCpPrime + costSpPrime));
    if totalCostPrime <= totalCost
        Usp(idxCell,idxUser) = 1;
        Ucp(idxCell,idxUser) = 0;
    else
        break
    end
end

cpNumUser = sum(Ucp,2);
spNumUser = sum(Usp,2);