function costSp = hybridCostFunctionSP(rxPower,Usp,numCell,numUser,coherenceTime,rhoP,rhoD,ulCost,dlCost)

% rhoD                = sqrt( 1 / ( 1 + sqrt((numBSAntenna+sum(sum(Usp)))/coherenceTime )) );
% rhoP                = sqrt(1 - rhoD^2);

InterfPowerSP_ul    = zeros(numCell,numUser);

for jj = 1:numCell
    for mm = 1:numUser
        for ll = 1:numCell
            for kk = 1:numUser
                if Usp(ll,kk) && Usp(jj,mm);
                    InterfPowerSP_ul(jj,mm) = InterfPowerSP_ul(jj,mm) + 1/(coherenceTime * rhoP^2) * rxPower{ll}(jj,mm)^2;
                end
            end
        end
    end
end

costSp =  InterfPowerSP_ul * ( ulCost + dlCost * rhoD^2 );

% for jj = 1:numCell
%     for mm = 1:numUser
%         if Usp(jj,mm)
%             for ll = 1:numCell
%                 for kk = 1:numUser
%                     if Usp(ll,kk)
%                         InterfPowerSP_dl(jj,mm) = InterfPowerSP_dl(jj,mm) + rhoD^2 / (coherenceTime * rhoP^2) * rxPower{ll}(jj,mm)^2  ;
%                     end
%                 end
%             end
%         end
%     end
% end