% Simulation code for "Downlink Performance of Superimposed Pilots in Massive MIMO Systems"
% by Karthik Upadhya, Sergiy Vorobyov, and Mikko Vehkaperä
% Accepted for publication in IEEE Transactions on Wireless Communications.
%
% This code generates Figures 9-10.

clc
clear all
close all

pilotTypeRange = {'hybrid','superimposed','regular'};
userRadiusRange= [0.2:0.1:0.6,0.62:0.02:0.78,0.8:0.1:0.9];

for pp = 1:numel(pilotTypeRange)
    for rr = 1:length(userRadiusRange)
        pilotType = pilotTypeRange{pp};
        userRadius= userRadiusRange(rr);
        [avgUlRate(rr),avgDlRate(rr)] = code9to10(pilotType,userRadius);        
    end
    figure(1);plot(userRadiusRange,avgUlRate);hold all; drawnow;
    figure(2);plot(userRadiusRange,avgDlRate);hold all; drawnow;
end
figure(1); legend(pilotTypeRange);xlabel('User radius');ylabel('UL Sum rate');
figure(2); legend(pilotTypeRange);xlabel('User radius');ylabel('DL Sum rate');