function [ulSumRate,dlSumRate] = code9to10( pilotType , userRadius )


% - Simulation Parameters - %
numTrials       = 1e4;
ulSnrDb         = 10;
dlSnrDb         = 10;
numSymbolUlTimeSlot   = 40;
% - System Parameters - %
numBSAntenna        = 600;
numCellTotal        = 19;
numCell             = 7;
numUser             = 5; % - Number of users per cell
ulCost              = 0.5;
dlCost              = 0.5;
rpTxPowerDb         = 0;
spTxPowerDb         = 10;

rpTxPower           = 10^(rpTxPowerDb/10);
spTxPower           = 10^(spTxPowerDb/10);

txPrecoderPowerDebug        = cell(1,numCellTotal);
interfTerm1Debug            = cell(1,numCell,numCellTotal,numUser);
[interfTerm1Debug{:}]       = deal(zeros(numTrials,numUser));
interfTerm2Debug            = cell(numCell,1);
[interfTerm2Debug{:}]       = deal(zeros(numTrials,numUser));
[txPrecoderPowerDebug{:}]   = deal(zeros(numTrials,numUser));

%%%% -- Channel Parameters - %%%%
channelParameter.pathLossCoeff          = 3;
channelParameter.cellRadius             = 1; % Cell radius in km
channelParameter.d0                     = 0.1;% Reference distance in km
channelParameter.userRadius             = userRadius;% User radius in km

center  = genCellCenters(numCellTotal) .* channelParameter.cellRadius;
msLocations         = cell(numCellTotal,1);
[msLocations{:}]    = deal(zeros(1,numUser));
userTxGain          = zeros(numCellTotal,numUser);
for ii = 1:numCellTotal
    msLocations{ii}     = channelParameter.userRadius * exp(1i * 2 * pi / numUser * (0:numUser-1)) + center(ii);
    userTxGain(ii,:) = -(channelParameter.pathLossCoeff * 10 * log10(channelParameter.d0./abs(msLocations{ii}-center(ii))));
end

for ii = 1:numCellTotal
    for jj = 1:numCellTotal
        rxPowerInDb = channelParameter.pathLossCoeff * 10 * log10(channelParameter.d0./abs(msLocations{jj}-center(ii))) + userTxGain(jj,:);
        betaVal     = 10.^(rxPowerInDb/10);
        channelParameter.betaVal{ii}(jj,:) = betaVal;
    end
end

channelParameter.ulNoiseVar = 10^(-ulSnrDb/10);
channelParameter.dlNoiseVar = 10^(-dlSnrDb/10);
channelParameter.sharedPilotCellIdx         = genSharedPilotCellIndex(numCellTotal,numCell);

[rhoVal,lambdaVal] = rhoLambdaCalc(channelParameter,numSymbolUlTimeSlot,numCell,numUser,numBSAntenna);
% lambdaVal                = sqrt( 1 / ( 1 + sqrt( numSymbolUlTimeSlot / ( numBSAntenna + numCell * numUser ) ) ) );
% rhoVal                   = sqrt( 1 - lambdaVal^2);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

switch lower(pilotType)
    case 'regular'
        Usp         = [zeros(numCell,numUser) ;zeros(numCellTotal-numCell,numUser)];
        Urp         = ones(numCellTotal,numUser) - Usp;
        rpNumUser   = sum(Urp,2);
    case 'superimposed'
        Usp         = [ones(numCell,numUser) ;zeros(numCellTotal-numCell,numUser)];
        Urp         = ones(numCellTotal,numUser) - Usp;
        rpNumUser   = sum(Urp,2);
    case 'hybrid'
        [Usp,Urp,rpNumUser]   = hybridParameterOptimization(numCellTotal,numUser,channelParameter,numSymbolUlTimeSlot,lambdaVal,rhoVal,ulCost,dlCost);
end
for ii = 1:numTrials
    
    channelMatrix       = cell(numCellTotal,numCellTotal);
    [channelMatrix{:}]  = deal(zeros(numBSAntenna,numUser));
    channelEstimate     = cell(numCellTotal,1);
    [channelEstimate{:}]= deal(zeros(numBSAntenna,numUser));
    
    
    for jj = 1:numCellTotal % Index of Reference Cell
        for ll = 1:numCellTotal
            G                   = cNormrnd(0,1,numBSAntenna,numUser);
            D                   = channelParameter.betaVal{jj}(ll,:);
            channelMatrix{jj,ll}= G * sparse(diag(sqrt(D)));
        end
    end
    
    rpPilotLength           = max(rpNumUser);
    %%%%% - Uplink Stage - %%%%%
    for jj = 1:numCellTotal % Index of reference cell
        rpIdx               = Urp(jj,:) == 1;
        spIdx               = Usp(jj,:) == 1;
        % - Generate channel estimates %
        ulAwgn   = complex( normrnd(0,1/sqrt(2),numBSAntenna,numUser) , normrnd(0,1/sqrt(2),numBSAntenna,numUser) );
        for ll = 1:numCellTotal
            channelEstimate{jj}(:,rpIdx & (Urp(ll,:) == 1)) = channelEstimate{jj}(:,rpIdx & (Urp(ll,:) == 1)) + channelMatrix{jj,ll}( : , rpIdx & (Urp(ll,:) == 1) );
        end
        channelEstimate{jj}(:,rpIdx)     = channelEstimate{jj}(:,rpIdx) + sqrt(channelParameter.ulNoiseVar / ( rpTxPower * rpPilotLength ))  * ulAwgn(:,rpIdx);
        
        ulTxData = complex( normrnd(0,1/sqrt(2),numCellTotal,numUser) , normrnd(0,1/sqrt(2),numCellTotal,numUser) );
        for mm = 1:numUser
            if spIdx(mm)
                channelEstimate{jj}(:,mm) = channelEstimate{jj}(:,mm) + channelMatrix{jj,jj}(:,mm);
                for ll = 1:numCellTotal                    
                    for kk = 1:numUser
                        if Urp(ll,kk)
                            channelEstimate{jj}(:,mm) = channelEstimate{jj}(:,mm) + sqrt(rpTxPower / spTxPower) * 1/(sqrt(numSymbolUlTimeSlot - rpPilotLength) * lambdaVal) * channelMatrix{jj,ll}(:,kk) * ulTxData(ll,kk);
                        else
                            channelEstimate{jj}(:,mm) = channelEstimate{jj}(:,mm) + ( rhoVal / ( sqrt(numSymbolUlTimeSlot - rpPilotLength) * lambdaVal ) ) * channelMatrix{jj,ll}(:,kk) * ulTxData(ll,kk);
                        end
                    end
                end
                channelEstimate{jj}(:,mm) = channelEstimate{jj}(:,mm) + sqrt(channelParameter.ulNoiseVar) / (sqrt(numSymbolUlTimeSlot - rpPilotLength) * lambdaVal) * ulAwgn(:,mm);
            end
        end
        
        if jj <= numCell % Estimate signal and interference power only for the first tier of cells
            for mm = 1:numUser % Index of user
                rxCombiningVec              = channelEstimate{jj}(:,mm);
                
                for ll = 1:numCellTotal
                    for kk = 1:numUser
                        ulInterfTerm1{jj,mm,ll,kk}(ii)     = abs( rxCombiningVec' * channelMatrix{jj,ll}(:,kk) ).^2;
                    end
                end
                ulInterfTerm2{jj,mm}(ii)      = rxCombiningVec' * channelMatrix{jj,jj}(:,mm);
                ulInterfTerm3{jj,mm}(ii)      = (rxCombiningVec' * rxCombiningVec);
            end
        end
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%

    %%%% - Downlink Stage - %%%%%
    for ll = 1:numCellTotal
        for kk = 1:numUser
            txPrecodingVec= channelEstimate{ll}(:,kk); %
            txPrecoderPowerDebug{1,ll}(ii,kk)   = norm(txPrecodingVec,2)^2;
            for jj = 1:numCell % Index of reference cell
                interfTerm1Debug{jj,ll,kk}(ii,:) = abs( channelMatrix{ll,jj}' * txPrecodingVec ).^2;
                if ll == jj
                    tVec              = channelMatrix{jj,jj}' * txPrecodingVec;
                    interfTerm2Debug{ll}(ii,kk) = tVec(kk);
                end
            end
        end
    end
end

% - Calculate UL Achievable rate - %
interfTerm1 = zeros(numCell,numUser);
interfTerm2 = interfTerm1;
interfTerm3 = interfTerm1;
for jj = 1:numCell
    for mm = 1:numUser
        for ll = 1:numCellTotal
            for kk = 1:numUser
                if Urp(ll,kk)
                    interfTerm1(jj,mm) = interfTerm1(jj,mm) + rpTxPower * mean(ulInterfTerm1{jj,mm,ll,kk});
                else
                    interfTerm1(jj,mm) = interfTerm1(jj,mm) + spTxPower * rhoVal^2 * mean(ulInterfTerm1{jj,mm,ll,kk});
                    if ~(ll== jj && kk == mm)
                        interfTerm1(jj,mm) = interfTerm1(jj,mm) + spTxPower * lambdaVal^2 * (numSymbolUlTimeSlot - rpPilotLength) / (numSymbolUlTimeSlot - rpPilotLength - 1) * mean(ulInterfTerm1{jj,mm,ll,kk});
                    end
                end
            end
        end
        if Urp(jj,mm)
            interfTerm2(jj,mm) = - rpTxPower * abs(mean(ulInterfTerm2{jj,mm}))^2;
        else
            interfTerm2(jj,mm) = - spTxPower * rhoVal^2 * abs(mean(ulInterfTerm2{jj,mm}))^2;
        end
        interfTerm3(jj,mm) = channelParameter.ulNoiseVar * mean(ulInterfTerm3{jj,mm});
        sigTerm(jj,mm)     = - interfTerm2(jj,mm);
        sinrTerm(jj,mm)    = sigTerm(jj,mm) / ( interfTerm1(jj,mm) + interfTerm2(jj,mm) + interfTerm3(jj,mm) );
        ulAchRate(jj,mm)   = (numSymbolUlTimeSlot - rpPilotLength) / (2 *numSymbolUlTimeSlot) * log2( 1 + sinrTerm(jj,mm) );
    end
end
ulSumRate = sum(ulAchRate(:));

% - Calculate DL Achievable rate - %
interfTerm1 = zeros(numCell,numUser);
txPrecoderNormalizingFactor = zeros(numCell,numUser);
for ll = 1:numCellTotal
    for kk = 1:numUser
        txPrecoderNormalizingFactor(ll,kk) = 1./mean(txPrecoderPowerDebug{1,ll}(:,kk));
        for jj = 1:numCell
            interfTerm1(jj,:) = interfTerm1(jj,:) + txPrecoderNormalizingFactor(ll,kk) * mean(interfTerm1Debug{jj,ll,kk},1);
        end
    end
end

for jj = 1:numCell
    interfTerm2(jj,:) = - txPrecoderNormalizingFactor(jj,:) .* abs(mean(interfTerm2Debug{jj,1},1)).^2;
end
sigTerm     = - interfTerm2;
interfTerm3 = channelParameter.dlNoiseVar;

dlSinrSim = sigTerm ./ ( interfTerm1 + interfTerm2 + interfTerm3 );
dlAchRate = 1/2 * log2(1 + dlSinrSim);
dlSumRate = sum(dlAchRate(:));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%