% Simulation code for "Sparse channel estimation with lp-norm and reweighted
% l1-norm penalized least mean squares" by Omid Taheri and Sergiy Vorobyov
% published in ICASSP 2011


clc;
clear all;  
close all


% Parameters for Example 2

% SNR = 10; % SNR at output of channel
% NumSimulations = 100;
% CIRLen = 256;
% equalizer_length = CIRLen;
% mu = 0.005;
% rho = 2e-4;
% RZAeps = 10;
% rho_weighted = 5e-5;
% rho_p = 5e-6;
% epsilon_rw = 0.01;
% epsilon = 0.05;
% 
% p = 0.5;
% 
% training = [200:200:3000];  % length of training with BPSK data
% % number of spikes in the CIR
% T = 16;



% Parameters for Example 1

SNR = 10; % SNR values of 10 and 20 dB as in paper
NumSimulations = 500;
CIRLen = 16;
equalizer_length = CIRLen;
mu = 0.05;
rho = 5e-4;
RZAeps = 10;
rho_weighted = 5e-4;
rho_p = 5e-4;
epsilon_rw = 0.05;
epsilon = 0.05;
p = 0.5;
training = [25:25:250];  % length of training with BPSK data
% number of spikes in the CIR
T = 1; % T=1 for case 1 and T=2 for case 2


train_data = zeros(1,training); %training data
s = zeros(1,training);



progbarhandle = progbar(0,'Please wait...','','');


MSE = zeros(length(training),1);
MSE_l1penalized = zeros(length(training),1);
MSE_RZA = zeros(length(training),1);
MSE_lpPenalized = zeros(length(training),2);
MSE_Weightedl1Penalized = zeros(length(training),1);
for Ctr=1:length(training)
    for SimCtr= 1:NumSimulations
        channel = zeros(1,CIRLen);
        q = randperm(CIRLen);
        channel(q(1:T)) = randn(T,1);

        s(1:training(Ctr)) = sign(randn(1,training(Ctr))); 


        sigma_v = sqrt(norm(channel)^2/10^(SNR/10)); % Noise standard deviation

        v = zeros(1,training);

        v(1:training(Ctr))=(sigma_v)*(randn(1,training(Ctr)));

        y = filter(channel,1,s); % filters data through channel
        r = y + v;

        w  = zeros(equalizer_length,1); 
        u_hat  = zeros(1,equalizer_length);
        num_errors = 0;

        w_l1penalized  = zeros(equalizer_length,1);
        uhat_l1penalized = zeros(1,equalizer_length);
        num_errors_l1penalized = 0;
        
        w_RZA  = zeros(equalizer_length,1);
        uhat_RZA = zeros(1,equalizer_length);
        num_errors_RZA = 0;
        

        w_lpPenalized  = zeros(equalizer_length,2);
        uhat_lpPenalized = zeros(2,equalizer_length);
        
        w_Weightedl1Penalized  = zeros(equalizer_length,1);
        pastw_Weightedl1Penalized  = zeros(equalizer_length,1);
        uhat_Weightedl1Penalized = zeros(1,equalizer_length);
        num_errors_Weightedl1Penalized = 0;
        

        for i = 1:training(Ctr)
    
           u_hat  = [s(i) u_hat(1:equalizer_length-1)];
           LMSerr = r(i) - u_hat*w;
           w = w + mu*LMSerr*u_hat';


           uhat_l1penalized  = [s(i) uhat_l1penalized(1:equalizer_length-1)];
           LMSerr = r(i) - uhat_l1penalized*w_l1penalized;
           w_l1penalized = w_l1penalized - rho*sign(w_l1penalized) + mu*LMSerr*uhat_l1penalized';

           uhat_RZA  = [s(i) uhat_RZA(1:equalizer_length-1)];
           LMSerr = r(i) - uhat_RZA*w_RZA;
           w_RZA = w_RZA - rho*sign(w_RZA)./(1+RZAeps*abs(w_RZA)) + mu*LMSerr*uhat_RZA';


           uhat_Weightedl1Penalized  = [s(i) uhat_Weightedl1Penalized(1:equalizer_length-1)];
           LMSerr = r(i) - uhat_Weightedl1Penalized*w_Weightedl1Penalized;
           tempw_Weightedl1Penalized = w_Weightedl1Penalized;

           w_Weightedl1Penalized = w_Weightedl1Penalized - rho_weighted*sign(w_Weightedl1Penalized)./(epsilon_rw+abs(pastw_Weightedl1Penalized)) + mu*LMSerr*uhat_Weightedl1Penalized';
           pastw_Weightedl1Penalized = tempw_Weightedl1Penalized;
           
   
           uhat_lpPenalized(1,:)  = [s(i) uhat_lpPenalized(1,1:equalizer_length-1)];
           LMSerr = r(i) - uhat_lpPenalized(1,:)*w_lpPenalized(:,1);
           w_lpPenalized(:,1) = w_lpPenalized(:,1) + mu*LMSerr*uhat_lpPenalized(1,:)' ...
               - rho_p*(norm(w_lpPenalized(:,1),p(1))^(1-p(1)))*sign(w_lpPenalized(:,1))./(epsilon(1)+abs(w_lpPenalized(:,1)).^(1-p(1)));
   
        end


        MSE(Ctr) = MSE(Ctr) + (norm(w-channel'))^2/CIRLen;
        MSE_l1penalized(Ctr) = MSE_l1penalized(Ctr) + (norm(w_l1penalized - channel'))^2/CIRLen;
        MSE_RZA(Ctr) = MSE_RZA(Ctr) + (norm(w_RZA - channel'))^2/CIRLen;
        MSE_Weightedl1Penalized(Ctr) = MSE_Weightedl1Penalized(Ctr) + (norm(w_Weightedl1Penalized - channel'))^2/CIRLen;
        MSE_lpPenalized(Ctr,1) = MSE_lpPenalized(Ctr,1) + (norm(w_lpPenalized(:,1) - channel'))^2/CIRLen;
    end

    MSE(Ctr) = MSE(Ctr)/NumSimulations;
    MSE_l1penalized(Ctr) = MSE_l1penalized(Ctr)/NumSimulations;
    MSE_RZA(Ctr) = MSE_RZA(Ctr)/NumSimulations;
    MSE_Weightedl1Penalized(Ctr) = MSE_Weightedl1Penalized(Ctr)/NumSimulations;
    MSE_lpPenalized(Ctr,:) = MSE_lpPenalized(Ctr,:)./NumSimulations;
    
    progbar(((Ctr-1)*NumSimulations+SimCtr)/(NumSimulations*length(training)),progbarhandle);
end
clc;
close(progbarhandle);

linewidth = 2.5;
fontsize = 14;

semilogy(training,MSE,'--^k','MarkerSize',8,'LineWidth',linewidth);
hold on;
semilogy(training,MSE_l1penalized,':ok','MarkerSize',8,'LineWidth',linewidth);
semilogy(training,MSE_RZA,'--dk','MarkerSize',8,'LineWidth',linewidth);
semilogy(training,MSE_Weightedl1Penalized,'->k','MarkerSize',8,'LineWidth',linewidth);
semilogy(training,MSE_lpPenalized(:,1),'-.<k','MarkerSize',8,'LineWidth',linewidth);
legend('Standard LMS', 'ZA-LMS', 'RZA-LMS' , 'l_{p}-norm penalized LMS (p=0.5)','Reweighted l_{1}-norm penalized LMS');

set(gca,'FontSize',fontsize);
grid;

xlabel('Number of Iterations','fontsize',fontsize);
ylabel('MSE','fontsize',fontsize);