clc
clear;
nCounter=0;
LLL=8:2:20;
for n=LLL
    N_itr=200;                                 % Number of the independent runs for each point
    disp(n)
    N = 50;                                    % Number of the Sanpshots
    gammAA=10;                                 % Diagonal loading factor
    L=50;                                      % Number of the rays.
    %----------Locally Incoherently scattered source with Gaussian angular power density -------
    theta_s_actual = [30]*pi/180;
    angspread_actual=4/180*pi;
    theta_s_presumed = [34]*pi/180;
    angspread_presumed=6/180*pi;
    theta_i_actual = [10]*pi/180;
    %---------- Calculation of the actual steering vector of the signal
    NN=500;
    variance=(angspread_actual/2)^2;
    lengthofinterval=pi/(NN-1);
    A_s_actual=[];
    for teta=linspace(-pi/2,pi/2,NN)
        density =1/(sqrt(2*pi*variance))*exp(-(teta-theta_s_actual)^2/(2*variance))*lengthofinterval;
        A_s_actual=[A_s_actual exp(j*pi * [0:n-1]'*sin(teta))*sqrt(density)];
    end
    R_s_actual=A_s_actual*A_s_actual';          % Actual correlation matrix of the Desired Signal

    variance=(angspread_presumed/2)^2;
    A_s_presumed=[];
    for teta=linspace(-pi/2,pi/2,NN)
        density =1/(sqrt(2*pi*variance))*exp(-(teta-theta_s_presumed)^2/(2*variance))*lengthofinterval;
        A_s_presumed=[A_s_presumed exp(j*pi * [0:n-1]'*sin(teta))*sqrt(density)];
    end
    R_s_int=A_s_presumed*A_s_presumed';            % Presumed correlation matrix of the Desired Signal
    [AA BB]=eig(R_s_int);
    Q_int=(AA*BB.^(.5))';

    %---------- Calculation of the actual steering vector of Interferer
    angspread_actual2=10/180*pi;
    lengthofinterval=angspread_actual2/(NN-1);
    A_i_actual=[];
    for teta=linspace(theta_i_actual-angspread_actual2/2,theta_i_actual+angspread_actual2/2,NN)
        density =1/(angspread_actual2)*lengthofinterval;
        A_i_actual=[A_i_actual exp(j*pi * [0:n-1]'*sin(teta))*sqrt(density)];
    end
    A_i_actual=A_i_actual/sqrt(trace(A_i_actual*A_i_actual'))*sqrt(n);
    %-------------------------------------------------------------------------
    P_noise = 1;                               % Power of the noise
    INR = 30;                                  % Power of the Interferer
    SNR=-5;

    nCounter=nCounter+1;
    numberofIterations=10;
    MaximumNumberIterations=100;
    Firstmethod=zeros(numberofIterations,MaximumNumberIterations);
    Secondmethod=zeros(numberofIterations,MaximumNumberIterations);

    P_s = 10^(SNR/10);
    P_i = 10^(INR/10);
    R_s=R_s_int;
    Q=Q_int;
    eta=.5*sqrt(real(trace(R_s)));             % Value of the eta
    for iteration = 1:N_itr;
        s = randn(1,N) + 1i*randn(1,N);
        s = s - mean(s);

        s = sqrt(P_s)*(s/sqrt(var(s)));

        I = [];
        for i = 1:1
            jam = randn(1,N) + 1i*randn(1,N);
            jam = jam - mean(jam);
            jam = sqrt(P_i)*(jam/sqrt(var(jam)));
            I = [I; jam];
        end
        z = [];
        for i = 1:n
            z1 = randn(1,N) + 1i*randn(1,N);
            z1 = z1 - mean(z1);
            z1 = sqrt(P_noise)*(z1/sqrt(var(z1)));
            z = [z; z1];
        end

        angle_source=randn(N,L)*(angspread_actual/2)+theta_s_actual;
        angle_interfer=(rand(N,L)-.5)*angspread_actual+theta_i_actual;
        gain_s=exp(j*rand(N,L)*2*pi)/sqrt(L);
        gain_i=exp(j*rand(N,L)*2*pi)/sqrt(L);

        AS=[];
        for shomar=1:N
            AS=[AS  exp(j*pi * [0:n-1]'*sin(angle_source(shomar,1:L)))*gain_s(shomar,1:L)'];
        end

        AI=[];
        for shomar=1:N
            AI=[AI  exp(j*pi * [0:n-1]'*sin(angle_interfer(shomar,1:L)))*gain_i(shomar,1:L)'];
        end

        x_s = (AS) * diag(s);
        x_i_n =(AI) * diag(I(1,:)) + z;
        x = x_s + x_i_n;
        R = x*x'./N;
        R_i_n=x_i_n*x_i_n'./N;
        R_s_mont=x_s*x_s'/N;
        %===============
        R_i_n_actual= P_i*A_i_actual*A_i_actual'+eye(n);
        R=R + gammAA*eye(n);
        [eigvec,eigval]=eig(R);
        lammax=max(diag(eigval));
        lammin=min(diag(eigval));
        [eigvec,eigval]=eig(R_s);
        gammax=max(diag(eigval));
        gammin=min(diag(eigval));
        if eta/sqrt(gammax) >= 1
            disp('The optimzization problem in new proposed method is infeasible');
        end

        % ---Lower and Upper bounds for alpha----------------------------------------
        % --------------------------------------------------------------------------
        % --------------------------------------------------------------------------

        % ------- This part is for finding a feasible point which would be used to
        %         find a upperbound for Alpha
        lowerbound=max(1,1/(1-eta/sqrt(gammax))^2);
        cvx_begin sdp quiet
        variable W(n,n) hermitian;
        minimize trace(R*W)
        subject to
        trace(Q'*Q*W) == 1;
        trace(W) <= 1/eta^2;
        W >= 0
        cvx_end
        [u1 v1]=eig(W);
        [meg andis]=max(diag(v1));
        w0=u1(:,andis);
        scaling=abs(norm(Q*w0)-eta*norm(w0));
        w0=w0/scaling;
        upperbound=max(eig(inv(R)*Q'*Q))*w0'*R*w0;
        lowerbound=real(lowerbound);
        upperbound=real(upperbound);


        %---------------------New Proposed Method--------------------
        %------------------------------------------------------------
        %------------------------------------------------------------
        c=rand;
        clear yy
        alpha_int=(lowerbound*c+ upperbound*(1-c));
        acceptederror=10^(-6);
        tic
        for k=1:MaximumNumberIterations
            cvx_begin sdp quiet
            variable W(n,n) hermitian;
            variable alpha
            minimize trace(R*W)
            subject to
            trace(Q'*Q*W) == alpha;
            eta^2*trace(W) <= alpha-2*(alpha/(2*sqrt(alpha_int))+sqrt(alpha_int)/2)+1;
            %     alpha >= lowerbound;
            %     alpha <= upperbound;
            W >= 0
            cvx_end
            alpha_int=real(alpha);
            xx(k)=real(alpha);
            yy(k)=real(trace(R*W));
            if k >=2
                if (real(yy(k-1))-real(yy(k))) <= acceptederror
                    break;
                end
            end

        end
        time_spent1(nCounter,iteration)=toc;
        Number_of_iterations1(nCounter,iteration)=k;

        [u,v]=eig(W);
        [a,b]=max(diag(v));
        w_pro=sqrt(v(b,b))*u(:,b);

        if k==MaximumNumberIterations
            Firstmethod(iteration,:)=[yy];
        else
            Firstmethod(iteration,:)=[yy yy(k)*ones(1,MaximumNumberIterations-k)];
        end
        %
        c=-1;
        R_sn=[real(R_s) -imag(R_s)];
        R_sn=[R_sn; imag(R_s) real(R_s)];
        Rn=[real(R) -imag(R)];
        Rn=[Rn; imag(R) real(R)];

        while c <0
            w0=wgn(2*n,1,1);
            c=sqrt(real(w0'*R_sn*w0))-eta*norm(w0);
            w0=w0/c;
        end



        clear yyy
        tic
        for k=1:MaximumNumberIterations
            d=((R_sn*w0)/(sqrt(w0'*R_sn*w0)));
            cons=sqrt(real(w0'*R_sn*w0));
            cvx_begin quiet
            cvx_precision best
            variable w(2*n)
            minimize quad_form(w,Rn)
            subject to
            cons+(d'*(w-w0))-eta*norm(w) >=1 ;
            cvx_end
            yyy(k)=quad_form(w,Rn);
            w0=w;
            if k >=2
                if (real(yyy(k-1))-real(yyy(k))) <= acceptederror
                    break;
                end
            end

        end
        time_spent2(nCounter,iteration)=toc;
        Number_of_iterations2(nCounter,iteration)=k;


        if k ==MaximumNumberIterations
            Secondmethod(iteration,:)=[yyy ];
        else
            Secondmethod(iteration,:)=[yyy yyy(k)*ones(1,MaximumNumberIterations-k)];
        end


    end

end
a1=mean(time_spent1');
a2=mean(time_spent2');

b1=mean(Number_of_iterations1');
b2=mean(Number_of_iterations2');

