clc
clear;
n = 10;                             % Number of the Antenna Elements
N = 50;                             % Number of the Sanpshots
gammAA=10;                          % Diagonal loading factor
L=50;                              % Number of the rays.
% Signal Power
SNRcounter=0;
N_itr=100;
%for Width=.001:1:20
%  for Width=[.15, 1, 2, 5,9,14,16.5]
for Width=[1, 2, 5,9,14]
   
    %----------Locally Incoherently scattered source with Gaussian angular power density -------
    theta_s_actual = [30]*pi/180;
    angspread_actual=Width/180*pi;
    theta_s_presumed = [34]*pi/180;
    angspread_presumed=6/180*pi;
    %---------- Locally Incoherently scattered interferer with uniform angular power density -------
    theta_i_actual = [10]*pi/180;
    %---------- Calculation of the actual steering vector of the signal
    NN=500;
    variance=(angspread_actual/2)^2;
    lengthofinterval=pi/(NN-1);
    A_s_actual=[];
    for teta=linspace(-pi/2,pi/2,NN)
        density =1/(sqrt(2*pi*variance))*exp(-(teta-theta_s_actual)^2/(2*variance))*lengthofinterval;
        A_s_actual=[A_s_actual exp(j*pi * [0:n-1]'*sin(teta))*sqrt(density)];
    end
    R_s_actual=A_s_actual*A_s_actual';          % Actual correlation matrix of the Desired Signal


    [UR,SR,VR]=svd(R_s_actual);
    SS=diag(SR);

    ratio =.1;
    k=1;
    while ratio < (1-10^(-4))
        ratio=sum(SS(1:k))/trace(R_s_actual);
        k=k+1;
    end
    %     disp('Rank');
    %     disp(k)
    rankkk=k;
    variance=(angspread_presumed/2)^2;
    A_s_presumed=[];
    for teta=linspace(-pi/2,pi/2,NN)
        density =1/(sqrt(2*pi*variance))*exp(-(teta-theta_s_presumed)^2/(2*variance))*lengthofinterval;
        A_s_presumed=[A_s_presumed exp(j*pi * [0:n-1]'*sin(teta))*sqrt(density)];
    end
    R_s_int=A_s_presumed*A_s_presumed';            % Presumed correlation matrix of the Desired Signal
    [AA BB]=eig(R_s_int);
    Q_int=(AA*BB.^(.5))';

    %---------- Calculation of the actual steering vector of Interferer
    angspread_actual2=10/180*pi;
    lengthofinterval=angspread_actual2/(NN-1);
    A_i_actual=[];
    for teta=linspace(theta_i_actual-angspread_actual2/2,theta_i_actual+angspread_actual2/2,NN)
        density =1/(angspread_actual2)*lengthofinterval;
        A_i_actual=[A_i_actual exp(j*pi * [0:n-1]'*sin(teta))*sqrt(density)];
    end
    A_i_actual=A_i_actual/sqrt(trace(A_i_actual*A_i_actual'))*sqrt(n);
    %-------------------------------------------------------------------------
    P_noise = 1;                               % Power of the noise                                  % Number of the independent runs for each point
    INR = 30;                                  % Power of the Interferer
    % SNR =10;


    SNR=10;
    %disp('SNR');
    disp(SNR)
    P_s = 10^(SNR/10);
    P_i = 10^(INR/10);
    R_s=R_s_int;
    Q=Q_int;
    eta=.5*sqrt(real(trace(R_s)));             % Value of the eta
    SNRcounter=SNRcounter+1;
    for itr = 1:N_itr;
        disp([Width,itr])
        s = randn(1,N) + 1i*randn(1,N);
        s = s - mean(s);

        s = sqrt(P_s)*(s/sqrt(var(s)));

        I = [];
        for i = 1:1
            jam = randn(1,N) + 1i*randn(1,N);
            jam = jam - mean(jam);
            jam = sqrt(P_i)*(jam/sqrt(var(jam)));
            I = [I; jam];
        end
        z = [];
        for i = 1:n
            z1 = randn(1,N) + 1i*randn(1,N);
            z1 = z1 - mean(z1);
            z1 = sqrt(P_noise)*(z1/sqrt(var(z1)));
            z = [z; z1];
        end

        angle_source=randn(N,L)*(angspread_actual/2)+theta_s_actual;
        angle_interfer=(rand(N,L)-.5)*angspread_actual+theta_i_actual;
        gain_s=exp(j*rand(N,L)*2*pi)/sqrt(L);
        gain_i=exp(j*rand(N,L)*2*pi)/sqrt(L);

        AS=[];
        for shomar=1:N
            AS=[AS  exp(j*pi * [0:n-1]'*sin(angle_source(shomar,1:L)))*gain_s(shomar,1:L)'];
        end

        AI=[];
        for shomar=1:N
            AI=[AI  exp(j*pi * [0:n-1]'*sin(angle_interfer(shomar,1:L)))*gain_i(shomar,1:L)'];
        end

        x_s = (AS) * diag(s);
        x_i_n =(AI) * diag(I(1,:)) + z;
        x = x_s + x_i_n;
        R = x*x'./N;
        R_i_n=x_i_n*x_i_n'./N;
        R_s_mont=x_s*x_s'/N;
        %===============
        R_i_n_actual= P_i*A_i_actual*A_i_actual'+eye(n);
        R=R+gammAA*eye(n,n);
        %         AAA=wgn(n,n,10)+j*wgn(n,n,10);
        %         BBB=wgn(n,n,1)+j*wgn(n,n,1);
        %
        %         R_s=BBB*BBB';
        %         [AA BB]=eig(R_s);
        %         Q=(AA*BB.^(.5))';
        %         R=AAA*AAA';
        %         eta=.3*sqrt(real(trace(R_s)));             % Value of the eta

        [eigvec,eigval]=eig(R);
        lammax=max(diag(eigval));
        lammin=min(diag(eigval));
        [eigvec,eigval]=eig(R_s);
        gammax=max(diag(eigval));
        gammin=min(diag(eigval));
        if eta/sqrt(gammax) >= 1
            disp('The optimzization problem in new proposed method is infeasible');
        end

        % ---Lower and Upper bounds for alpha----------------------------------------
        % --------------------------------------------------------------------------
        % --------------------------------------------------------------------------

        % ------- This part is for finding a feasible point which would be used to
        %         find a upperbound for Alpha
        lowerbound=max(1,1/(1-eta/sqrt(gammax))^2);
        cvx_begin sdp quiet
        variable W(n,n) hermitian;
        minimize trace(R*W)
        subject to
        trace(Q'*Q*W) == 1;
        trace(W) <= 1/eta^2;
        W >= 0
        cvx_end
        [u1 v1]=eig(W);
        [meg andis]=max(diag(v1));
        w0=u1(:,andis);
        scaling=abs(norm(Q*w0)-eta*norm(w0));
        w0=w0/scaling;
        upperbound=max(eig(inv(R)*Q'*Q))*w0'*R*w0;
        lowerbound=real(lowerbound);
        upperbound=real(upperbound);
        %---------------------New Proposed Method--------------------
        %------------------------------------------------------------
        %------------------------------------------------------------
        alpha_int=lowerbound;
        acceptederror=10^(-12);
        for k=1:60
            cvx_begin sdp quiet
            variable W(n,n) hermitian;
            variable alpha
            minimize trace(R*W)
            subject to
            trace(Q'*Q*W) == alpha;
            eta^2*trace(W) <= alpha-2*(alpha/(2*sqrt(alpha_int))+sqrt(alpha_int)/2)+1;
            %             alpha >= lowerbound;
            %             alpha <= upperbound;
            W >= 0
            cvx_end
            alpha_int=real(alpha);
            xx(k)=real(alpha);
            yy(k)=trace(R*W);
            ObjectiveVALUE(itr,k,SNRcounter)=trace(R*W);
            if k >=2
                if (real(yy(k-1))-real(yy(k))) <= acceptederror
                    break;
                end
            end

        end
        [u,v]=eig(W);
        [a,b]=max(diag(v));
        w_pro=sqrt(v(b,b))*u(:,b);
        Number_of_iterations=k;

        %         %---Plot for using Exhausitve Search---------------------------------------
        %         % --------------------------------------------------------------------------
        %         % % --------------------------------------------------------------------------
        l1= lowerbound;
        l2=real(max(eig(inv(R)*Q'*Q))*w_pro'*R*w_pro);
        counter=0;
        clear x
        clear y
        AlphaGrid=l1:(l2-l1)/50:l2;
        for alphanum=AlphaGrid(1:end-1)
            counter=counter+1;
            cvx_begin sdp quiet
            variable W(n,n) hermitian;
            variable alpha
            minimize trace(R*W)
            subject to
            trace(Q'*Q*W)== alpha;
            %trace(W) <= (sqrt(alpha)-1)^2/eta^2;
            trace(W) <= (alpha+1-2*((alpha-AlphaGrid(counter))/(sqrt(AlphaGrid(counter+1))+sqrt(AlphaGrid(counter)))+sqrt(AlphaGrid(counter))))/eta^2;
            W >= 0
            alpha >= l1
            alpha <= l2
            cvx_end
            x(counter)=alphanum;
            yyyy(counter)=trace(R*W);
        end
        %         %          plot(x,y,'r')
        %         [aa bb]=min(y);
        %         alpha=x(bb);
        %         cvx_begin sdp quiet
        %         variable W(n,n) hermitian;
        %         minimize trace(R*W)
        %         subject to
        %         trace(Q'*Q*W)== alpha;
        %         trace(W) <= (sqrt(alpha)-1)^2/eta^2;
        %         W >= 0
        %         cvx_end
        %         [u,v]=eig(W);
        %         [a,b]=max(diag(v));
        %         w_exs=sqrt(v(b,b))*u(:,b);




        %         %---Old method--BISECTION -------------------------------------------------
        %         % -------------------------------------------------------------------------
        %         % -------------------------------------------------------------------------
        %
        %
        %         tau=10^(-4);
        %         l=0;
        %         u=1;
        %         oo=0;
        %         while (u-l > tau)
        %
        %             oo=oo+1;
        %             c=(l+u)/2;
        %
        %             cvx_begin sdp quiet
        %             variable W(n,n) hermitian;
        %             subject to
        %             trace(W)==(1-c)^2/eta^2;
        %             trace(Q'*Q*W)==1;
        %             W >= 0
        %             cvx_end
        %             if  cvx_optval == 0
        %                 l=c;
        %             else
        %                 u=c;
        %             end
        %             vvv(oo)=c;
        %             mmm(oo)=l;
        %             nnn(oo)=u;
        %             disp(c)
        %         end
        %         c=l;
        %         cvx_begin sdp quiet
        %             variable W2(n,n) hermitian;
        %             subject to
        %             trace(W2)==(1-c)^2/eta^2;
        %             trace(Q'*Q*W2)==1;
        %             W2 >= 0
        %             cvx_end
        %         [u,v]=eig(W2);
        %         [a,b]=max(diag(v));
        %         w_old=u(:,b);
        %         scaling=norm(Q*w_old)-eta*norm(w_old);
        %         w_old=w_old/scaling;



        %---------------------Optimal Weight--------------------
        %------------------------------------------------------------
        %------------------------------------------------------------
        Aopt=inv(R_i_n_actual)*R_s_actual;
        [u,v]=eig(Aopt);
        [a,b]=max(diag(v));
        w_opt=u(:,b);


        %---------------------Shahram--------------------
        %------------------------------------------------------------
        %------------------------------------------------------------

        etashahram=8;
        Ashah=inv(R)*(R_s-etashahram*eye(n));
        %         [ushah,vshah]=eig(Ashah);
        %         [ashah,bshah]=max(diag(vshah));
        %         w_shah=ushah(:,bshah);

        [ushah,sshah]=eig(Ashah);
        [mm,nn]=max(real(diag(sshah)));
        w_shah=ushah(:,nn);
        scaling=norm(Q*w_shah)-eta*norm(w_shah);
        w_shah=w_shah/scaling;

        %---------------------Optimal Weight-Iterative--------------------
        %------------------------------------------------------------
        %------------------------------------------------------------

        %        W0=w_shah*w_shah';
        W0=eye(n,n);
        for k=1:10
            cvx_begin sdp quiet
            variable W_iterative(n,n) hermitian;
            minimize trace(R*W_iterative)
            subject to
            trace(R_s*W_iterative) - eta^2 *trace(W_iterative)-1 >= 2*(eta)*(sqrt(trace(W0)));
            W_iterative >= 0;
            cvx_end
            W0=W_iterative;
        end

        [u_iterative,v_iterative]=eig(W0);
        [a_iterative,b_iterative]=max(diag(v_iterative));
        w_old_iterative=sqrt(v_iterative(b_iterative,b_iterative))*u_iterative(:,b_iterative);
        %         scaling=norm(Q*w_old_iterative)-eta*norm(w_old_iterative);
        w_old_iterative=w_old_iterative/scaling;


        %---------------------Low Complexity Method --------------------
        %------------------------------------------------------------
        %------------------------------------------------------------
        etanew=eta;
        LargestEigen=max(eig(R_s));
        ALowCom=inv(R)*(R_s+etanew^2*eye(n,n)-2*etanew*sqrt(LargestEigen)*eye(n,n));
        [uLowCom,sLowCom]=eig(ALowCom);
        eigenvector=real(diag(sLowCom));
        [value_lambda index]=max(eigenvector);
        w_LowCom=uLowCom(:,index);
        scaling=norm(Q*w_LowCom)-etanew*norm(w_LowCom);
        w_LowCom=w_LowCom/scaling;


        %---------------------Worst-case Rank One --------------------
        %------------------------------------------------------------
        %------------------------------------------------------------

        as= exp(j*pi * [0:n-1]'*sin(theta_s_presumed));
        Rss=R;
        epsilon=3;
        cvx_begin
        variable wrob(n) complex;
        variable t
        %minimize quad_form( wrob , Rss+0.1*eye(10,10) )
        minimize t
        subject to
        quad_form(wrob,Rss) <=t
        imag(wrob'*as)==0
        real(wrob'*as) >= epsilon*norm(wrob) +1
        cvx_end




        %----------------------------Computation of SINR and objective
        % ----------------------------------------------
        %--------------------------------------------------------------------------
        %--------------------------------------------------------------------------
        SINR_opt(SNRcounter,itr)=P_s*(w_opt'*R_s_actual*w_opt)/(w_opt'*R_i_n_actual*w_opt);
        % SINR_exs(SNRcounter,itr)=P_s*(w_exs'*R_s_actual*w_exs)/(w_exs'*R_i_n_actual*w_exs);
        SINR_pro(SNRcounter,itr)=P_s*(w_pro'*R_s_actual*w_pro)/(w_pro'*R_i_n_actual*w_pro);
        % SINR_old(SNRcounter,itr)=P_s*(w_old'*R_s_actual*w_old)/(w_old'*R_i_n_actual*w_old);
        SINR_old_iterative(SNRcounter,itr)=P_s*(w_old_iterative'*R_s_actual*w_old_iterative)/(w_old_iterative'*R_i_n_actual*w_old_iterative);
        SINR_shah(SNRcounter,itr)=P_s*(w_shah'*R_s_actual*w_shah)/(w_shah'*R_i_n_actual*w_shah);
        SINR_LowCom(SNRcounter,itr)=P_s*(w_LowCom'*R_s_actual*w_LowCom)/(w_LowCom'*R_i_n_actual*w_LowCom);
        SINR_rob(SNRcounter,itr)=P_s*(wrob'*R_s_actual*wrob)/(wrob'*R_i_n_actual*wrob);
        Itercounter(SNRcounter,itr)=Number_of_iterations;


        scaling=norm(Q*w_old_iterative)-eta*norm(w_old_iterative);
        w_old_iterative=w_old_iterative/scaling;

        Objective_pro(SNRcounter,itr)=w_pro'*R*w_pro;
        Objective_exs(SNRcounter,itr)=min(yyyy);

        %  Objective_old(SNRcounter,itr)=w_old'*R*w_old;
        Objective_old_iterative(SNRcounter,itr)=w_old_iterative'*R*w_old_iterative;
        Objective_shah(SNRcounter,itr)=w_shah'*R*w_shah;
        Objective_LowCom(SNRcounter,itr)=w_LowCom'*R*w_LowCom;

    end
    SNRsave(SNRcounter)=Width;
    Rank(SNRcounter)=rankkk;
end


[row, col] = find(isnan(SINR_rob));
SINR_rob(:,col)=[];

SNRsave=Rank;
MARKERS=['b   ';'c   ';'r  s';'r-- ';'r:  ';'b-. '];
MARKERSIZE=[6 6 10 15 15 15];
LINEWIDTH=[4 3 3 3 3 3 3];
COLOR=[0 0 1; 0.87 .49 0 ;1 0 0;0 .75 .75 ;0.6 0.2 0; 0.08 0.17 0.55];

figure
plot(SNRsave,10*log10(mean(real(SINR_opt),2)),MARKERS(1,:),'Color',COLOR(1,:),'MarkerSize',MARKERSIZE(1),'LineWidth',LINEWIDTH(1))
hold on
plot(SNRsave,10*log10(mean(real(SINR_pro),2)),MARKERS(2,:),'Color',COLOR(2,:),'MarkerSize',MARKERSIZE(2),'LineWidth',LINEWIDTH(2))
%plot(SNRsave,10*log10(mean(real(SINR_pro),2)),MARKERS(3,:),'Color',COLOR(3,:),'MarkerSize',MARKERSIZE(3),'LineWidth',LINEWIDTH(3))
plot(SNRsave,10*log10(mean(real(SINR_old_iterative),2)),MARKERS(4,:),'Color',COLOR(4,:),'MarkerSize',MARKERSIZE(4),'LineWidth',LINEWIDTH(4))
plot(SNRsave,10*log10(mean(real(SINR_shah),2)),MARKERS(5,:),'Color',COLOR(5,:),'MarkerSize',MARKERSIZE(5),'LineWidth',LINEWIDTH(5))
plot(SNRsave,10*log10(mean(real(SINR_LowCom),2)),MARKERS(6,:),'Color',COLOR(6,:),'MarkerSize',MARKERSIZE(6),'LineWidth',LINEWIDTH(6))
plot(SNRsave,10*log10(mean(real(SINR_rob),2)),MARKERS(2,:),'Color',COLOR(6,:),'MarkerSize',MARKERSIZE(6),'LineWidth',LINEWIDTH(6))
legend('Optimal','Proposed Method','Method of [13]','Method of [12]','Methed of [14]','Rank One Worst Case Based RAB',2);
xlabel('SNR (dB)')
ylabel('SINR(dB)')
grid




figure
%  plot(SNRsave,10*log10(mean(real(Objective_exs),2)),'g')
hold on
plot(SNRsave,(mean(real(Objective_pro),2)),MARKERS(2,:),'Color',COLOR(2,:),'MarkerSize',MARKERSIZE(2),'LineWidth',LINEWIDTH(2))
plot(SNRsave,(mean(real(Objective_exs),2)),MARKERS(3,:),'Color',COLOR(3,:),'MarkerSize',MARKERSIZE(3),'LineWidth',LINEWIDTH(3))
plot(SNRsave,(mean(real(Objective_old_iterative),2)),MARKERS(4,:),'Color',COLOR(4,:),'MarkerSize',MARKERSIZE(4),'LineWidth',LINEWIDTH(4))
plot(SNRsave,(mean(real(Objective_shah),2)),MARKERS(2,:),'Color',COLOR(5,:),'MarkerSize',MARKERSIZE(5),'LineWidth',LINEWIDTH(5))
plot(SNRsave,(mean(real(Objective_LowCom),2)),MARKERS(2,:),'Color',COLOR(6,:),'MarkerSize',MARKERSIZE(6),'LineWidth',LINEWIDTH(6))
legend('Proposed Method','Lower-Bound','Method of [12]','Method of [11]','Methed of [13]',2);
xlabel('SNR (dB)')
ylabel('Objective Value')
grid

