function out=FluctuatedLaplacian(zall,x,y,Spread)
Nz=length(zall);
for Zindex=1:Nz
    z=zall(Zindex);
    N=length(x)-1;
    a=x(1);
    b=x(N+1);
    Delta=(b-a)/N;
    if (z <= a) || (z >= b)
        out(Zindex)=0;
    else
        indeks=floor((z-a)/Delta)+1;
        fz=y(indeks)+(y(indeks+1)-y(indeks))/(x(indeks+1)-x(indeks))*(z-x(indeks));
        out(Zindex)=abs(exp(-sqrt(2)*abs(z-(a+b)/2)/Spread)+fz);
    end
end