clc
clear
theta_s_actual = [30]*pi/180;
angspread_actual=4/180*pi;
theta_s_presumed = [34]*pi/180;
angspread_presumed=6/180*pi;
variance=(angspread_presumed/2)^2;


Spread=.1;
n=50;
Width=30/180*pi;
LowerLimit=theta_s_actual-Width/2;
UpperLimit=theta_s_actual+Width/2;
xLap=linspace(LowerLimit,UpperLimit,n);
yLap=(wgn(1,n,.01))/10;
 
NN=500;
variance=(angspread_presumed/2)^2;
lengthofinterval=pi/(NN-1);
counter=0;
C=quad(@(phi)FluctuatedLaplacian(phi,xLap,yLap,Spread),min(xLap),max(xLap));
for teta=linspace(min(xLap),max(xLap),NN)
    counter=counter+1;
    densityGauss(counter) =1/(sqrt(2*pi*variance))*exp(-(teta-theta_s_presumed)^2/(2*variance));
    densityLaplace(counter) = FluctuatedLaplacian(teta,xLap,yLap,Spread)/C;
    angles(counter)=teta;
end
 
plot(angles/pi*180,densityGauss);
hold on
plot(angles/pi*180,densityLaplace,'r');