% This program maps the MN x 1 into (M+N) x 1 ULA
M = 10;                                            % Total number of transmitting antennas
N = 10;                                            % Total number of receiving antennas
dt = 0.5;                                          % transmitter spacings in wavelength
dr = 0.5;
Theta = [3 5];
L_tar = length(Theta);
At = exp( -j*2*pi*dt*(0:M-1)'*sin(Theta*pi/180) );        % Uplink steering vectors
Ar = exp( -j*2*pi*dr*(0:N-1)'*sin(Theta*pi/180) );         % Downlink steering vectors; Tx and Rx are assumed to be close to each other
T = 100;                                           % number of radar pulses (slow-time)
Twaveform = 2000;                                  % number of samples per waveform in one pulse (fast-time)

% generate orthogonal (random) waveforms
Nb = 2;                                            % number of communication bits per pulse
Waveforms = sqrt(0.5)*( randn(2*Nb, Twaveform) + 1i*randn(2*Nb, Twaveform) );
for ii = 1:2*Nb
    WaveTemp = Waveforms(ii,:);
    WaveTemp = WaveTemp - mean(WaveTemp);
    Waveforms(ii,:) = WaveTemp;
end
Rwave = Waveforms*Waveforms';
[U,D,V] = svd(Rwave);
Rroot = U*inv( sqrt(D));
Waveforms = Rroot'*Waveforms;
%%%%%%===============================
load Weights
WTx1 = w(:, 1);
NormalizFactor = sqrt( M/trace(WTx1*WTx1') );
WTx1 = NormalizFactor*WTx1;
Abeams1 = WTx1'*At;
s_new1 = Abeams1.'*Waveforms(1,:);
% 
WTx2 = [];
for mm=1:M
    if abs( WTx1(mm) )^2 <= 1
        WTx2 = [WTx2; WTx1(mm)];
    else
        WTx2 = [WTx2; WTx1(mm)/abs(WTx1(mm))];
    end
end
Abeams2 = WTx2'*At;
s_new2 = Abeams2.'*Waveforms(1,:);
%
WTx3 = W;
NormalizFactor = sqrt( M/trace(WTx3*WTx3') );
WTx3 = NormalizFactor*WTx3;
Abeams3 = WTx3'*At;
s_new3 = Abeams3.'*Waveforms(1:4,:);
%
WTx4 = [];
for mm=1:M
    v = WTx3(mm,:);
    if norm( v )^2 <= 1
        WTx4 = [WTx4; v];
    else
        WTx4 = [WTx4; v/norm(v)];
    end
end
Abeams4 = WTx4'*At;
s_new4 = Abeams4.'*Waveforms(1:4,:);
%%%%%%%%%%%%%%%%%%%        Spectral grid    %%%%%%%%%
Grid = [ linspace(-90, -10.01,81) linspace(-10, Theta(1)-1.01,121)...
    linspace(Theta(1)-1, Theta(2) + 1, 4001) linspace(Theta(2) + 1.01 ,10,51)...
    linspace(10.01, 90,81)];
Agrid = exp( -1i*2*pi*dr*(0:N-1)'*sin(Grid*pi/180) );
Atg = exp( -1i*2*pi*dr*(0:M-1)'*sin(Grid*pi/180) );
ATx1 = WTx1'*Atg;
ATx2 = WTx2'*Atg;
ATx3 = WTx3'*Atg;
ATx4 = WTx4'*Atg;
%%%%%%%%%%%%%%  MonteCarlo trials   %%%%%%%%%%%%%%%%%%%%%%%
P_noise = 1;
SNR = [-30:5:-5 -4:1:4 5:5:30];
MSE = zeros(length(SNR), 4);
RESOL = zeros(length(SNR), 4);
montcarlo = 1000;
for itr = 1:montcarlo, itr
    Beta =  exp( 1i*2*pi*rand(L_tar,T) );%sqrt(0.5)*( randn(L_tar,T) + 1i*randn(L_tar,T) );
    %
    Z = [];
    for n_pulse = 1:T;
        z = sqrt(P_noise/2)*( randn(N, Twaveform) + 1i*randn(N, Twaveform) );
        zTemp = z*conj(Waveforms.');
        Z = [Z reshape( zTemp, 2*Nb*N, 1 ) ];
    end
    VarZ = diag(1./sqrt(var(Z.')));
    Z = VarZ*Z;
    for snr = 1:length(SNR)
        Ptar = 10^(SNR(snr)/10);
        Beta_tar = sqrt(Ptar)*Beta;
        x_new1 = [];
        x_new2 = [];
        x_new3 = [];
        x_new4 = [];
        for n_pulse = 1:T;
            % compute signals observed at targets
            s_tar_new1 = diag(Beta_tar(:,n_pulse))*s_new1;
            x_tar_new1 = Ar*s_tar_new1;
            x_new1 = [x_new1 reshape( x_tar_new1*conj( Waveforms(1,:) ).', N,1 ) ];
            %
            s_tar_new2 = diag(Beta_tar(:,n_pulse))*s_new2;
            x_tar_new2 = Ar*s_tar_new2;
            x_new2 = [x_new2 reshape( x_tar_new2*conj( Waveforms(1,:) ).', N,1 ) ];
            %
            s_tar_new3 = diag(Beta_tar(:,n_pulse))*s_new3;
            x_tar_new3 = Ar*s_tar_new3;
            x_new3 = [x_new3 reshape( x_tar_new3*conj( Waveforms(1:4,:) ).', 4*N,1 ) ];
            %
            s_tar_new4 = diag(Beta_tar(:,n_pulse))*s_new4;
            x_tar_new4 = Ar*s_tar_new4;
            x_new4 = [x_new4 reshape( x_tar_new4*conj( Waveforms(1:4,:) ).', 4*N,1 ) ];
            %
        end
        x_new1 = x_new1 + Z(1:N,:);
        R_new1 = (1/T)*x_new1*x_new1';
        [U,D,V] = svd(R_new1);
        Un1 = U(:,L_tar+1:N);
        %
        x_new2 = x_new2 + Z(1:N,:);
        R_new2 = (1/T)*x_new2*x_new2';
        [U,D,V] = svd(R_new2);
        Un2 = U(:,L_tar+1:N);
        %
        x_new3 = x_new3 + Z(1:4*N,:);
        R_new3 = (1/T)*x_new3*x_new3';
        [U,D,V] = svd(R_new3);
        Un3 = U(:,L_tar+1:4*N);
        %
        x_new4 = x_new4 + Z(1:4*N,:);
        R_new4 = (1/T)*x_new4*x_new4';
        [U,D,V] = svd(R_new4);
        Un4 = U(:,L_tar+1:4*N);
        %%%%%
        for ii = 1:length(Grid)
            vsv = kron( ATx1(:,ii), Agrid(:, ii) );
            MUSIC1(ii) = (vsv'*vsv)/abs( vsv'*Un1*Un1'*vsv );
            %
            vsv = kron( ATx2(:,ii), Agrid(:, ii) );
            MUSIC2(ii) = (vsv'*vsv)/abs( vsv'*Un2*Un2'*vsv );
            %
            vsv = kron( ATx3(:,ii), Agrid(:, ii) );
            MUSIC3(ii) = (vsv'*vsv)/abs( vsv'*Un3*Un3'*vsv );
            %
            vsv = kron( ATx4(:,ii), Agrid(:, ii) );
            MUSIC4(ii) = (vsv'*vsv)/abs( vsv'*Un4*Un4'*vsv );            
            %
        end
        MUSIC1 = MUSIC1/(max(MUSIC1));
        MUSIC2 = MUSIC2/(max(MUSIC2));
        MUSIC3 = MUSIC3/(max(MUSIC3));
        MUSIC4 = MUSIC4/(max(MUSIC4));
        %
        [peak_index] = MUSICpeaks(MUSIC1, L_tar);
        DOA_new1 = Grid(peak_index);
        MSE(snr, 1) = MSE(snr, 1) + mean( (Theta - DOA_new1).^2 );
        RESOL(snr, 1) = RESOL(snr, 1) + prob_resolution(Theta, DOA_new1);
        %
        [peak_index] = MUSICpeaks(MUSIC2, L_tar);
        DOA_new2 = Grid(peak_index);
        MSE(snr, 2) = MSE(snr, 2) + mean( (Theta - DOA_new2).^2 );
        RESOL(snr, 2) = RESOL(snr, 2) + prob_resolution(Theta, DOA_new2);
        %
        [peak_index] = MUSICpeaks(MUSIC3, L_tar);
        DOA_new3 = Grid(peak_index);
        MSE(snr, 3) = MSE(snr, 3) + mean( (Theta - DOA_new3).^2 );
        RESOL(snr, 3) = RESOL(snr, 3) + prob_resolution(Theta, DOA_new3);
        %
        [peak_index] = MUSICpeaks(MUSIC4, L_tar);
        DOA_new4 = Grid(peak_index);
        MSE(snr, 4) = MSE(snr, 4) + mean( (Theta - DOA_new4).^2 );
        RESOL(snr, 4) = RESOL(snr, 4) + prob_resolution(Theta, DOA_new4);
    end
end
SNR, RMSE = sqrt(MSE/montcarlo), RESOL = RESOL/montcarlo
save DOAestimationResults-5To5dB
figure
semilogy(SNR, RMSE(:,1), '-*r', SNR, RMSE(:,2), '-+k', SNR, RMSE(:,3), '-xm', SNR, RMSE(:,4), '-ob'), grid
legend('SIMO radar without transmit power clipping', 'SIMO radar with transmit power clipping', 'MIMO radar without transmit power clipping', 'MIMO radar with transmit power clipping')
% %
figure
plot(SNR, RESOL(:,1), '-*r', SNR, RESOL(:,2), '-+k', SNR, RESOL(:,3), '-xm', SNR, RESOL(:,4), '-ob'), grid
legend('SIMO radar without transmit power clipping', 'SIMO radar with transmit power clipping', 'MIMO radar without transmit power clipping', 'MIMO radar with transmit power clipping')

