% This function computes the prob of resolution of DOA estimation based on
% VanTrees, Ch9
function resol = prob_resolution(theta_act, theta_est)
% We assume that the number of DOAs is 2.
theta_act = sort(theta_act(:));
theta_est = sort(theta_est(:));
delta = (theta_act(2)-theta_act(1))/2;
d1 = abs(theta_est(1) - theta_act(1));
d2 = abs(theta_est(2) - theta_act(2));
if (d1 <= delta)
    resol_1 = 1;
else
    resol_1 = 0;
end
if (d2 <= delta)
    resol_2 = 1;
else
    resol_2 = 0;
end
%resol = (resol_1 + resol_2)/2;
resol = (resol_1 * resol_2);