clear all

K = 2; % Number of complex exponentials (or the number of sources). 
M = 8; % Number of array elements. 
N = 100; % The number of snapshots or the number of samples used for 
        % estimating the sample covariance matrix 
d_lambda = 0.5; % d/lambda   

theta = -(pi/2):0.01:(pi/2); % Used as the grid in the spectral MUSIC method.

sigma2noise = 1; % Noise variance

freqs_deg = [35 37]'; % freqs should be in [-90,90] range
freqs_rad = freqs_deg*pi/180;

CorrelationCoef = 0; % between 0 and 1
if CorrelationCoef == 0
    cr = 0;
else
    cr = (1-sqrt(1-CorrelationCoef^2))/CorrelationCoef;
end;

SourceCorrelation = [1 cr;cr 1]/sqrt(1+cr^2);

SNR = 20; %(dB)

sigma2source = 10^(0.1*SNR)*sigma2noise;  % Signal power

idxR = (0:(M-1))'; 

A = zeros(M,K);
for i = 1:K
    A(:,i) = exp(-1i*2*pi*d_lambda*sin(freqs_rad(i))*idxR);
end

A = A/sqrt(M); % So that each column of A has unit norm.

s = zeros(K,N);
noise = zeros(M,N);
x0 = zeros(M,N);
R = zeros(M,M); 

S = M*sigma2source*SourceCorrelation;
V = A*S*(A');
R_true = V + sigma2noise*eye(M); % [U31Jul13]

for i = 1:N
    s(:,i) = sqrt(sigma2source/2)*(randn(K,1)+1i*randn(K,1))*sqrt(M);
    s(:,i) = SourceCorrelation*s(:,i);
    noise(:,i) = sqrt(sigma2noise/2)*(randn(M,1)+1i*randn(M,1));
    x0(:,i) = A*s(:,i) + noise(:,i);
    R = R + x0(:,i)*(x0(:,i)');
end
R = R/N;

% Compute eigendecomposition and order by descending eigenvalues

[Q0,D0] = eig(R);
[lambdahat,idx] = sort(abs(diag(D0))); % Ascending order: lambdahat1 <= lambdahat2 <= ...
Q = Q0(:,idx);

G = Q(:,1:(M-K));
GGH = G * (G'); 

% MUSIC

%[fhat_Music_rad, etaMUSIC] = music_doa(GGH,M,K,theta,d_lambda);% The output is in [-pi/2,pi/2] range % 

%plot(theta*180/pi, 1./etaMUSIC);

% root-MUSIC

fhat_root_Music_rad = root_music_doa(G,M,K,d_lambda); % The output is in [-pi/2,pi/2] range
fhat_root_Music_deg = fhat_root_Music_rad * 180 / pi; 




% Conventional Beamformer

[fhat_CBF_rad, f_CBF, fhat_CBF_left_rad, fhat_CBF_right_rad] = ...
    conventional_beamformer(R(:,:,1), M, K, theta, d_lambda); % [U17Mar14]
fhat_CBF_deg = fhat_CBF_rad * 180/pi;
fhat_CBF_left_deg = fhat_CBF_left_rad * 180/pi;
fhat_CBF_right_deg = fhat_CBF_right_rad * 180/pi;




% unitary-root-MUSIC


i = floor(M/2);
I_i = eye(i, i);
J_i = fliplr(I_i);
O_i = zeros(i, 1);

if ( M - 2*i == 0 )
    Q_M = [I_i 1i*I_i; J_i -1i*J_i] / sqrt(2);
else
    Q_M = [I_i O_i 1i*I_i; O_i' sqrt(2) O_i'; J_i O_i -1i*J_i] / sqrt(2);
end


% [fhat_unitary_root_Music_rad, sigmahat2noise, mag_unitary_root_Music] = unitary_root_music_doa(R, Q_M, M, K, d_lambda);



C = real((Q_M') * R * Q_M); % [U13Feb14]
%   = 0.5 * (Q_M') * (R + J_M * conj(R) * J_M) * Q_M; 

[Q0, D0] = eig(C);
% [Q0, D0] = eig(R); 

[lambda_hat, idx_lambda] = sort(abs(diag(D0))); % Ascending order: lambdahat1 <= lambdahat2 <= ...
Q_sorted = Q0(:,idx_lambda);
E_N = Q_sorted(:,1:(M-K));
G = Q_M * E_N;
% G = E_N;

% [U13Feb14] }

sigma2_n = sum(lambda_hat(1:(M-K))) / (M-K); % [U31Mar14]

Ar = zeros(2*M-1,1);
for i = 1:(M-K)
   Ar = Ar + conv(G(M:-1:1,i), conj(G(:,i)));    
end
fest = zeros(K,1);
maghatroot_Music_rad = zeros(K,1); % [U3Apr14]
r_A = roots(Ar);

distinct_roots_num = 0;
unit_roots_indx = find(abs(r_A) == 1);
unit_roots_num = length(unit_roots_indx);
if (unit_roots_num~=0)
    unit_roots = r_A(unit_roots_indx);
    distinct_roots_indx = 1:2:unit_roots_num;
    distinct_roots_num = length(distinct_roots_indx);
    fest(1:distinct_roots_num) = angle(unit_roots(distinct_roots_indx));
    maghatroot_Music_rad(1:distinct_roots_num) = 1; % [U3Apr14]    
end
[i_min] = find(abs(r_A) < 1);
r_A_min = r_A(i_min);
freqsroot_MUSIC = angle(r_A_min);
[~,index] = sort(abs((abs(r_A_min) -1)));
fest((distinct_roots_num+1):K) = freqsroot_MUSIC(index(1:(K-distinct_roots_num)));  % DOA estimates

maghatroot_Music_rad((distinct_roots_num+1):K) = abs(r_A_min(index(1:(K-distinct_roots_num)))); % [U3Apr14]

[fhat_unitary_root_Music_rad, idx] = sort(asin(fest/(2*pi*d_lambda)));

mag_unitary_root_Music = maghatroot_Music_rad(idx); % [U3Apr14]


fhat_unitary_root_Music_deg = fhat_unitary_root_Music_rad * 180 / pi;


r_test = reliability_test_beamforming(fhat_unitary_root_Music_rad, fhat_CBF_left_rad, fhat_CBF_right_rad);




% pseudo_noise_resample

Ppnr = 0;


sigma_n = sqrt(sigma2_n);

fhat_rad_bank = zeros(K, Ppnr);
mag_bank = zeros(K, Ppnr);

reliability = zeros(1, Ppnr);


for P_iter = 1:Ppnr
    
    pseudo_noise = sigma_n * randn(M,N); 
    x0_r = x0 + pseudo_noise; % Resampled data
    R_r = x0_r * (x0_r') / N; % Resampled covariance matrix
    
    
    % unitary-root-MUSIC

    
      
    C = real((Q_M') * R_r * Q_M); % [U13Feb14]
    %   = 0.5 * (Q_M') * (R + J_M * conj(R) * J_M) * Q_M;
    
    [Q0, D0] = eig(C);
    [lambda_hat, idx_lambda] = sort(abs(diag(D0))); % Ascending order: lambdahat1 <= lambdahat2 <= ...
    Q_sorted = Q0(:,idx_lambda);
    E_N = Q_sorted(:,1:(M-K));
    G = Q_M * E_N;
    
    % [U13Feb14] }
    
    
    Ar = zeros(2*M-1,1);
    for i = 1:(M-K)
        Ar = Ar + conv(G(M:-1:1,i), conj(G(:,i)));
    end
    fest = zeros(K,1);
    maghatroot_Music_rad = zeros(K,1); % [U3Apr14]
    r_A = roots(Ar);
    
    distinct_roots_num = 0;
    unit_roots_indx = find(abs(r_A) == 1);
    unit_roots_num = length(unit_roots_indx);
    if (unit_roots_num~=0)
        unit_roots = r_A(unit_roots_indx);
        distinct_roots_indx = 1:2:unit_roots_num;
        distinct_roots_num = length(distinct_roots_indx);
        fest(1:distinct_roots_num) = angle(unit_roots(distinct_roots_indx));
        maghatroot_Music_rad(1:distinct_roots_num) = 1; % [U3Apr14]
    end
    [i_min] = find(abs(r_A) < 1);
    r_A_min = r_A(i_min);
    freqsroot_MUSIC = angle(r_A_min);
    [~,index] = sort(abs((abs(r_A_min) -1)));
    fest((distinct_roots_num+1):K) = freqsroot_MUSIC(index(1:(K-distinct_roots_num)));  % DOA estimates
    
    maghatroot_Music_rad((distinct_roots_num+1):K) = abs(r_A_min(index(1:(K-distinct_roots_num)))); % [U3Apr14]
    
    [fhat_unitary_root_Music_rad, idx] = sort(asin(fest/(2*pi*d_lambda)));
    
    mag_unitary_root_Music = maghatroot_Music_rad(idx); % [U3Apr14]
    
    
    fhat_unitary_root_Music_deg = fhat_unitary_root_Music_rad * 180 / pi;
    
    
    fhat_rad_bank(:, P_iter) = fhat_unitary_root_Music_rad;
    mag_bank(:, P_iter) = mag_unitary_root_Music;
    
    
    reliability(P_iter) = reliability_test_beamforming(fhat_rad_bank(:, P_iter), fhat_CBF_left_rad, fhat_CBF_right_rad);
    
end

if (Ppnr ~= 0)
    if (sum(reliability) == 0)
        [~, idx] = max(mag_bank, [], 2); % Finding the index of the max element in each row.
        fhat_rad = zeros(K,1);
        for i = 1:K
            fhat_rad(i) = fhat_rad_bank(i, idx(i));
        end
    else
        fhat_rad = mean(fhat_rad_bank(:, reliability == 1), 2);
    end
end




%}