% University of Alberta 
% Mahdi Shaghaghi
% 30 August 2012
% Updated: 13 Feb 2014 [U13Feb14]: built on root_music_doa.m
% Ref: Improved unitary root-MUSIC for DOA estimation based on pseudo-noise
% resampling, C. Qian, Feb 2014.

% Updated: 31 Mar 2014 [U31Mar14]: sigma2_n is estimated.

% Updated: 3 Apr 2014 [U3Apr14]: magnitude of roots are also returned. 

function [fhatroot_Music_rad, sigma2_n, maghatroot_Music_rad] = unitary_root_music_doa(R, Q_M, M, K, d_lambda)

% [U13Feb14] {
% J_M = fliplr(eye(M, M)); 

C = real((Q_M') * R * Q_M); % [U13Feb14]
%   = 0.5 * (Q_M') * (R + J_M * conj(R) * J_M) * Q_M; 

[Q0, D0] = eig(C);
[lambda_hat, idx] = sort(abs(diag(D0))); % Ascending order: lambdahat1 <= lambdahat2 <= ...
Q_sorted = Q0(:,idx);
E_N = Q_sorted(:,1:(M-K));
G = Q_M * E_N;

% [U13Feb14] }

sigma2_n = sum(lambda_hat(1:(M-K))) / (M-K); % [U31Mar14]

Ar = zeros(2*M-1,1);
for i = 1:(M-K)
   Ar = Ar + conv(G(M:-1:1,i), conj(G(:,i)));    
end
fest = zeros(K,1);
maghatroot_Music_rad = zeros(K,1); % [U3Apr14]
r_A = roots(Ar);

distinct_roots_num = 0;
unit_roots_indx = find(abs(r_A) == 1);
unit_roots_num = length(unit_roots_indx);
if (unit_roots_num~=0)
    unit_roots = r_A(unit_roots_indx);
    distinct_roots_indx = 1:2:unit_roots_num;
    distinct_roots_num = length(distinct_roots_indx);
    fest(1:distinct_roots_num) = angle(unit_roots(distinct_roots_indx));
    maghatroot_Music_rad(1:distinct_roots_num) = 1; % [U3Apr14]    
end
[i_min] = find(abs(r_A) < 1);
r_A_min = r_A(i_min);
freqsroot_MUSIC = angle(r_A_min);
[~,index] = sort(abs((abs(r_A_min) -1)));
fest((distinct_roots_num+1):K) = freqsroot_MUSIC(index(1:(K-distinct_roots_num)));  % DOA estimates

maghatroot_Music_rad((distinct_roots_num+1):K) = abs(r_A_min(index(1:(K-distinct_roots_num)))); % [U3Apr14]

[fhatroot_Music_rad, idx] = sort(asin(fest/(2*pi*d_lambda)));

maghatroot_Music_rad = maghatroot_Music_rad(idx); % [U3Apr14]


