% University of Alberta 
% Mahdi Shaghaghi
% 30 August 2012

% Updated: 3 Apr 2014 [U3Apr14]: magnitude of roots are also returned. 

function [fhatroot_Music_rad, maghatroot_Music_rad] = root_music_doa(G,M,K,d_lambda)

Ar = zeros(2*M-1,1);
for i = 1:(M-K)
   Ar = Ar + conv(G(M:-1:1,i),conj(G(:,i))); 
end
fest = zeros(K,1);
maghatroot_Music_rad = zeros(K,1); % [U3Apr14]
r_A = roots(Ar);

distinct_roots_num = 0;
unit_roots_indx = find(abs(r_A) == 1);
unit_roots_num = length(unit_roots_indx);
if (unit_roots_num~=0)
    unit_roots = r_A(unit_roots_indx);
    distinct_roots_indx = 1:2:unit_roots_num;
    distinct_roots_num = length(distinct_roots_indx);
    fest(1:distinct_roots_num) = angle(unit_roots(distinct_roots_indx));
    maghatroot_Music_rad(1:distinct_roots_num) = 1; % [U3Apr14]
end
[i_min] = find(abs(r_A) < 1);
r_A_min = r_A(i_min);
freqsroot_MUSIC = angle(r_A_min);
[~,index] = sort(abs((abs(r_A_min) -1)));
fest((distinct_roots_num+1):K) = freqsroot_MUSIC(index(1:(K-distinct_roots_num)));  % DOA estimates

maghatroot_Music_rad((distinct_roots_num+1):K) = abs(r_A_min(index(1:(K-distinct_roots_num)))); % [U3Apr14]

[fhatroot_Music_rad, idx] = sort(asin(fest/(2*pi*d_lambda)));

maghatroot_Music_rad = maghatroot_Music_rad(idx); % [U3Apr14]
