% Iterative root-MUSIC for DOA estimation 
% Used as a sub-routine for Performance_analysis.m
% Currently one or two sources are considered.
% Correlated sources are also considere. (3 Oct. 2012)
% Mahdi Shaghaghi
% University of Alberta
% 10 September 2012
% Updated: 3 October 2012
% Upadted: 18 October 2012 [Uoct1812]: using cvx to determine max gamma 
%          subject to preserving positive definiteness of R 
% Updated: 14 November 2012 [Unov1412]: a miss happens if one or more
%          frequencies is not resolved. In other words a successful detection
%          happens when all the frequencies are resolved.
%          MSE is computed only for successful detections.

% Updated: 27 May 2013 [U27May13]: a miss happens if the estimated frequency
%          is not resolved. MSE, CMSE, and detection probability are
%          considered separately for each frequency.
%          CMSE is computed only for successful detections.
%          MSE, CMSE, and detection probability are also computed considering 
%          all frequencies as subspace_leakage_I_root_Musiit was done on [Unov1412]. 

% Updated: 3 June 2013 [U3Jun13]

% Updated: 5 June 2013 [U5Jun13]: Automatic gamma selection as the
% minimizer of norm(sum(tmp+tmp'))

% Updated: 2 July 2013 [U2Jul13]: gamma selection based on minimizing the
%   squared Frobenius norm of the distance between the estimated and true
%   signal projection matrices: min ||hat( A(A'A)^(-1)A') -
%   A(A'A)^(-1)A'||_F^2  

% Updated: 4 July 2013 [U4Jul13]: gamma selection based on minimizing the
%   angle between subspace spanned by hat(A) and subspace spanned by hat(E)
%   where hat(E) is the signal eigenvectors of hat(R) 

% Updated: 31 July 2013 [U31Jul13]: oracle gamma selection based on minimizing the
%   squared Frobenius norm of the distance between the estimated and true
%   covariance matrices (at the second iteration): min ||hat(R)_1 - R||_F^2

% Updated: 7 Jan 2013 [U7Jan14]: gamma selection based on Maximum
% Likelihooh objective. Built on
% i_root_MUSIC_DOA_est_sub_routine_v34.m

% Updated: 15 Jan 2014 [U15Jan14]: A new modified root-MUSIC method is used.
% Specifically, different combinations of the roots are considered, and the
% one with minimum ML objective is used as the output of the root-MUSIC
% method.
% Built on i_root_MUSIC_DOA_est_sub_routine_v60.m
            
% Updated: 22 Jan 2014 [U22Jan14]: Subspace leakage is investigated over 
% iterations. Subspace leakage is defined as 
% rho = 1 - 1/K * Tr( PAhat * PA) 

% Updated: 12 Feb 2014 [U12Feb14]: Unitary root-MUSIC is used.
% Built on i_root_MUSIC_DOA_est_sub_routine_v61.m

% Updated: 18 Feb 2014 [U18Feb14]: root-swap-unitary-root-MUSIC is
% considered.

% Updated: 12 Mar 2014: [U12Mar14]: CRB is computed.

% Updated: 17 Mar 2014: [U17Mar14]: 
% a) Stochastic ML objectice function is
% also considered. ref: eq (2.20), Stoica, 1990, Performance Study of 
% Conditional and Unconditional Direction-of-Arrival Estimation
% b) Conventional beamformer is tested.

% Updated: 31 Mar 2014: [U31Mar14]: Pseudo-Noise resampling is tested

% Updated: 20 Apr 2014: [U20Apr14]: gamma * ( U + U' ) is subtracted from
% the resampled covariance matrix (in pseudo_noise_resample function).  

% Updated: 22 Apr 2014: [U22Apr14]: gamma * ( U + U' ) is subtracted from
% the resampled covariance matrix (in pseudo_noise_resample function) even
% at the first iteration. The initial value of gamma is used here.

% Updated:5 June 2014 [U5Jun14]: R_true corrected!

% Updated: 27 Aug 2014 [U27Aug14]: Subspace leakage variance is obtained through simulation. 
 


MSE_ind_I_root_Music = zeros(K,I_root_Music_max_itr); %[U27May13] unconditional MSE (in radians^2)
CMSE_ind_I_root_Music = zeros(K,I_root_Music_max_itr); %[U27May13] conditioned on successful detection
miss_ind_I_root_Music = zeros(K,I_root_Music_max_itr); %[U27May13] total number of misses in frequency/DOA estimation

MSE_tot_I_root_Music = zeros(1,I_root_Music_max_itr); %[U27May13] total (all frequencies/DOAs)
CMSE_tot_I_root_Music = zeros(1,I_root_Music_max_itr); %[U27May13] 
miss_tot_I_root_Music = zeros(1,I_root_Music_max_itr); %[U27May13] 

subspace_swaps_tot_I_root_Music = zeros(1,I_root_Music_max_itr); %[U7Jan14]
subspace_leakage_I_root_Music = zeros(1,I_root_Music_max_itr); %[U22Jan14]
subspace_leakage_I_root_Music_2 = zeros(1,I_root_Music_max_itr); %[U27Aug14]

shat = zeros(K,N,I_root_Music_max_itr);
noisehat = zeros(M,N,I_root_Music_max_itr);

Q = zeros(M,M,I_root_Music_max_itr); %[U3Jun13]
lambdahat = zeros(M,I_root_Music_max_itr); %[U3Jun13];

gamma_mean = 0; %[U5Jun13]
gamma_var = 0; %[U5Jun13]

idxR = (0:(M-1))'; % Used for the sample covariance matrix

A = zeros(M,K);
for i = 1:K
    A(:,i) = exp(-1i*2*pi*d_lambda*sin(freqs_rad(i))*idxR);
end

s = zeros(K,N);
noise = zeros(M,N);

x0 = zeros(M,N);

Ahat = zeros(M,K);

% S = M*sigma2source*SourceCorrelation;
% S = sigma2source*SourceCorrelation; 
S = sigma2source * SourceCorrelation * (SourceCorrelation'); % [U5Jun14]
V = A*S*(A');
R_true = V + sigma2noise*eye(M); % [U31Jul13]
[Q0,D0] = eig(R_true);
[lambda,idx] = sort(abs(diag(D0))); % Ascending order: lambda1 <= lambda2 <= ...
Q_true = Q0(:,idx); % [U7Jan14]
E_true = Q_true(:,(M-K+1):M); % [U7Jan14]

PA = A*((A')*A)^(-1)*(A');

% [U12Mar14] {
PA_orth = eye(M,M) - PA;
D = -1i * diag(0:(M-1)) * A * diag(cos(freqs_rad)) * 2*pi*d_lambda;
CRB = sigma2noise/(2*N) * ...
    (real( ((D') * PA_orth * D) .* transpose(S * (A') * (R_true^(-1)) * A * S) ))^(-1);

CRB_MSE = trace(CRB);
% [U12Mar14] }

% [U12Feb14] {
i = floor(M/2);
I_i = eye(i, i);
J_i = fliplr(I_i);
O_i = zeros(i, 1);

if ( M - 2*i == 0 )
    Q_M = [I_i 1i*I_i; J_i -1i*J_i] / sqrt(2);
else
    Q_M = [I_i O_i 1i*I_i; O_i' sqrt(2) O_i'; J_i O_i -1i*J_i] / sqrt(2);
end
% [U12Feb14] }

test_fail_count = zeros(1,I_root_Music_max_itr); % [U31Mar14]

for iter = 1:MCiters

    R = zeros(M,M,I_root_Music_max_itr); % added on [Uoct1812]
    
% First iteration of iterative root-MUSIC   
    
    for i = 1:N
        s(:,i) = sqrt(sigma2source/2)*(randn(K,1)+1i*randn(K,1)); 
        s(:,i) = SourceCorrelation*s(:,i);
        noise(:,i) = sqrt(sigma2noise/2)*(randn(M,1)+1i*randn(M,1));
        x0(:,i) = A*s(:,i) + noise(:,i);
        R(:,:,1) = R(:,:,1)+ x0(:,i)*(x0(:,i)');
    end
    R(:,:,1) = R(:,:,1)/N;     
    
% Compute eigendecomposition and order by ascending eigenvalues

    [Q0,D0] = eig(R(:,:,1));
    [lambdahat(:,1),idx] = sort(abs(diag(D0))); % Ascending order: lambdahat1 <= lambdahat2 <= ...
    Q(:,:,1) = Q0(:,idx);
    
    sigmahat2noise = sum(lambdahat(1:(M-K),1)) / (M-K); % [U31Mar14]

    G = Q(:,1:(M-K),1);
    E = Q(:,(M-K+1):M,1); % [U7Jan14]
    EEH = E * (E'); % [U7Jan14]
    
% Checking for subspace swaps [U7Jan14]

    tmp = 0;
    for i = 1:K
        if ( real((E_true(:,i)') * EEH * E_true(:,i)) < 0.5 )
            tmp = 1;
            break
        end
    end
    
    subspace_swaps_tot_I_root_Music(1) = subspace_swaps_tot_I_root_Music(1) + tmp; 
    
    tmp = 1 - 1/K * real( trace( EEH * PA ) );
    subspace_leakage_I_root_Music(1) = subspace_leakage_I_root_Music(1) + tmp; % [U22Jan14]
    subspace_leakage_I_root_Music_2(1) = subspace_leakage_I_root_Music_2(1) + tmp^2; % [U27Aug14]
    
% Conventional beamformer  

    [fhat_CBF_rad, f_CBF, fhat_CBF_left_rad, fhat_CBF_right_rad] = ...
        conventional_beamformer(R(:,:,1), M, K, theta, d_lambda); % [U17Mar14]
    fhat_CBF_deg = fhat_CBF_rad * 180/pi;
    fhat_CBF_left_deg = fhat_CBF_left_rad * 180/pi;
    fhat_CBF_right_deg = fhat_CBF_right_rad * 180/pi;
    
% root-MUSIC

    fhatI_root_Music_rad = zeros(K,I_root_Music_max_itr);
    
    if (strcmp(DOA_method, 'root-MUSIC'))
        fhatI_root_Music_rad(:,1) = root_music_doa(G,M,K,d_lambda); % The output is in [-pi/2,pi/2] range 
    elseif (strcmp(DOA_method, 'root-swap-root-MUSIC'))
        fhatI_root_Music_rad(:,1) = root_swap_root_music_doa(R(:,:,1),G,M,K,d_lambda, p_r, q_r, ML_method); % [U15Jan14] % [U17Mar14]
    elseif (strcmp(DOA_method, 'unitary-root-MUSIC'))
        [fhatI_root_Music_rad(:,1), sigmahat2noise] = unitary_root_music_doa(R(:,:,1), Q_M, M, K, d_lambda); % [U12Feb14] 
    elseif (strcmp(DOA_method, 'root-swap-unitary-root-MUSIC'))
        [fhatI_root_Music_rad(:,1), sigmahat2noise] = root_swap_unitary_root_music_doa(R(:,:,1), R(:,:,1), Q_M, M, K, d_lambda, p_r, q_r, ML_method); % [U18Feb14] % [U17Mar14] 
    end
    
    if (P>0) % [U31Mar14]
        if ( ~reliability_test_beamforming(fhatI_root_Music_rad(:,1), fhat_CBF_left_rad, fhat_CBF_right_rad) )
            % [U22Apr14] {

            for i = 1:K
                Ahat(:,i) = exp(-1i*2*pi*d_lambda*sin(fhatI_root_Music_rad(i,1))*idxR);
            end
    
            PAhat = Ahat*((Ahat')*Ahat)^(-1)*(Ahat');
            PA_orthhat = eye(M,M) - PAhat;
            
            U = PAhat * R(:,:,1) * PA_orthhat;
            % [U22Apr14] }
            
            test_fail_count(1) = test_fail_count(1) + 1;
            fhatI_root_Music_rad(:,1) = pseudo_noise_resample(x0, R(:,:,1), Q_M, K, d_lambda, ...
                p_r, q_r, ML_method, P, sigmahat2noise, fhat_CBF_left_rad, fhat_CBF_right_rad, DOA_method, gamma, U); % [U20Apr14] [U22Apr14]
        end
    end

    [SE_tot, SE_ind, misses_no] = computeSE(freqs_rad,fhatI_root_Music_rad(:,1),error_trsh); %[U27May13]

    MSE_tot_I_root_Music(1) = MSE_tot_I_root_Music(1)+SE_tot; %[U27May13]
    MSE_ind_I_root_Music(:,1) = MSE_ind_I_root_Music(:,1)+SE_ind; %[U27May13]
    CMSE_ind_I_root_Music(:,1) = CMSE_ind_I_root_Music(:,1)+SE_ind.*(1-misses_no); %[U27May13]
    miss_ind_I_root_Music(:,1) = miss_ind_I_root_Music(:,1)+misses_no; %[U27May13]
    
    if sum(misses_no) ~= 0
        miss_tot_I_root_Music(1) = miss_tot_I_root_Music(1)+1; %[U27May13]
    else
        CMSE_tot_I_root_Music(1) = CMSE_tot_I_root_Music(1)+SE_tot; %[U27May13]
    end
    
    
% Automatic gamma selection 

    if (auto_gamma_selection)
        for i = 1:K
            Ahat(:,i) = exp(-1i*2*pi*d_lambda*sin(fhatI_root_Music_rad(i,1))*idxR);
        end
    
        PAhat = Ahat*((Ahat')*Ahat)^(-1)*(Ahat');
        PA_orthhat = eye(M,M) - PAhat;
    
        U = PAhat * R(:,:,1) * PA_orthhat; % [U7Jan14]
    
        ML_objective = zeros(gamma_grid_size,1);
    
        for gamma_tmp_idx = 1:gamma_grid_size
        
            gamma_tmp = (gamma_tmp_idx-1)/(gamma_grid_size-1);
        
            R_tmp = R(:,:,1) - gamma_tmp * ( U + U' );
        
            % Compute eigendecomposition and order by ascending eigenvalues
        
            [Q0,D0] = eig(R_tmp);
            [lambdahat_tmp,idx] = sort(abs(diag(D0))); % Ascending order: lambdahat1 <= lambdahat2 <= ...
        
            Q_tmp = Q0(:,idx);
            G = Q_tmp(:,1:(M-K));
            E = Q_tmp(:, (M-K+1):M); % [U4Jul13]
        
            % I_root-MUSIC
        
            if (strcmp(DOA_method, 'root-MUSIC'))
                fhatI_root_Music_rad_tmp = root_music_doa(G,M,K,d_lambda); % The output is in [-pi/2,pi/2] range
            elseif (strcmp(DOA_method, 'root-swap-root-MUSIC'))
                fhatI_root_Music_rad_tmp = root_swap_root_music_doa(R(:,:,1), G, M, K, d_lambda, p_r, q_r, ML_method); % [U15Jan14] % [U17Mar14]
            elseif (strcmp(DOA_method, 'unitary-root-MUSIC'))
                fhatI_root_Music_rad_tmp = unitary_root_music_doa(R_tmp, Q_M, M, K, d_lambda); % [U12Feb14]
            elseif (strcmp(DOA_method, 'root-swap-unitary-root-MUSIC'))
                fhatI_root_Music_rad_tmp = root_swap_unitary_root_music_doa(R(:,:,1), R_tmp, Q_M, M, K, d_lambda, p_r, q_r, ML_method); % [U18Feb14] % [U17Mar14]
            end
        
            for i = 1:K
                Ahat(:,i) = exp(-1i*2*pi*d_lambda*sin(fhatI_root_Music_rad_tmp(i))*idxR);
            end
            PAhat = Ahat*((Ahat')*Ahat)^(-1)*(Ahat');
            PA_orthhat = eye(M,M) - PAhat;
        
            if (strcmp(ML_method, 'Stochastic')) % [U17Mar14]
                ML_objective(gamma_tmp_idx) = log( real( det( PAhat * R(:,:,1) * PAhat + ...
                    trace( PA_orthhat * R(:,:,1) ) * PA_orthhat / (M-K) ) ) );
            elseif (strcmp(ML_method, 'Deterministic'))
                ML_objective(gamma_tmp_idx) = real( -trace( PAhat * R(:,:,1) ) ); % [U7Jan14]
            end
        
        end
    
        [~,idx] = min(ML_objective);
    
        gamma = (idx-1)/(gamma_grid_size-1);
    end

    gamma_mean = gamma_mean+gamma;
    gamma_var = gamma_var+gamma^2;
    
% Second iteration onwards of iterative root-MUSIC

    for I_root_Music_iter = 2:I_root_Music_max_itr
    
        for i = 1:K
            Ahat(:,i) = exp(-1i*2*pi*d_lambda*sin(fhatI_root_Music_rad(i,I_root_Music_iter-1))*idxR);
        end
        
        PAhat = Ahat*((Ahat')*Ahat)^(-1)*(Ahat');
        PA_orthhat = eye(M,M) - PAhat;    
    
        U = PAhat * R(:,:,1) * PA_orthhat; % [U7Jan14]   
        
        ptmp = PAhat;
        Rtmp = R(:,:,1);
        
        R(:,:,I_root_Music_iter) = R(:,:,1) - gamma * ( U + U' ); % [U7Jan14]

% Compute eigendecomposition and order by ascending eigenvalues

        [Q0,D0] = eig(R(:,:,I_root_Music_iter));
        [lambdahat(:,I_root_Music_iter),idx] = sort(abs(diag(D0))); % Ascending order: lambdahat1 <= lambdahat2 <= ...
        Q(:,:,I_root_Music_iter) = Q0(:,idx);

        G = Q(:,1:(M-K),I_root_Music_iter);
        E = Q(:, (M-K+1):M, I_root_Music_iter); % [U7Jan14]
        EEH = E * (E'); % [U7Jan14]
        
        sigmahat2noise = sum(lambdahat(1:(M-K), I_root_Music_iter)) / (M-K); % [U31Mar14]      
        
% Checking for subspace swaps [U7Jan14]
        
        tmp = 0;
        for i = 1:K
            if ( real((E_true(:,i)') * EEH * E_true(:,i)) < 0.5 )
                tmp = 1;
                break
            end
        end
        
        subspace_swaps_tot_I_root_Music(I_root_Music_iter) = ...
            subspace_swaps_tot_I_root_Music(I_root_Music_iter) + tmp;       
        
        tmp = 1 - 1/K * real( trace( EEH * PA ) );
        subspace_leakage_I_root_Music(I_root_Music_iter) = ...
            subspace_leakage_I_root_Music(I_root_Music_iter) + tmp; % [U22Jan14]
        
        subspace_leakage_I_root_Music_2(I_root_Music_iter) = ...
            subspace_leakage_I_root_Music_2(I_root_Music_iter) + tmp^2; % [U27Aug14]

% I_root-MUSIC

        if (strcmp(DOA_method, 'root-MUSIC'))        
            fhatI_root_Music_rad(:,I_root_Music_iter) = root_music_doa(G,M,K,d_lambda); % The output is in [-pi/2,pi/2] range            
        elseif (strcmp(DOA_method, 'root-swap-root-MUSIC'))
            fhatI_root_Music_rad(:,I_root_Music_iter) = root_swap_root_music_doa(R(:,:,1), G, M, K, d_lambda, p_r, q_r, ML_method); % [U15Jan14] % [U17Mar14] 
        elseif (strcmp(DOA_method, 'unitary-root-MUSIC'))
            [fhatI_root_Music_rad(:,I_root_Music_iter), sigmahat2noise] = unitary_root_music_doa(R(:,:,I_root_Music_iter), Q_M, M, K, d_lambda); % [U12Feb14] 
        elseif (strcmp(DOA_method, 'root-swap-unitary-root-MUSIC'))
            [fhatI_root_Music_rad(:,I_root_Music_iter), sigmahat2noise] = root_swap_unitary_root_music_doa(R(:,:,1), ...
                R(:,:,I_root_Music_iter), Q_M, M, K, d_lambda, p_r, q_r, ML_method); % [U18Feb14] % [U17Mar14] 
        end
        
        if (P>0) % [U31Mar14]
            if ( ~reliability_test_beamforming(fhatI_root_Music_rad(:,I_root_Music_iter), fhat_CBF_left_rad, fhat_CBF_right_rad) )
                test_fail_count(I_root_Music_iter) = test_fail_count(I_root_Music_iter) + 1;
                fhatI_root_Music_rad(:,I_root_Music_iter) = pseudo_noise_resample(x0, R(:,:,1), Q_M, K, d_lambda, ...
                    p_r, q_r, ML_method, P, sigmahat2noise, fhat_CBF_left_rad, fhat_CBF_right_rad, DOA_method, gamma, U); % [U20Apr14]
            end
        end
        
        [SE_tot, SE_ind, misses_no] = computeSE(freqs_rad,fhatI_root_Music_rad(:,I_root_Music_iter),error_trsh); %[U27May13]

        MSE_tot_I_root_Music(I_root_Music_iter) = MSE_tot_I_root_Music(I_root_Music_iter)+SE_tot; %[U27May13]
        MSE_ind_I_root_Music(:,I_root_Music_iter) = MSE_ind_I_root_Music(:,I_root_Music_iter)+SE_ind; %[U27May13]
        CMSE_ind_I_root_Music(:,I_root_Music_iter) = CMSE_ind_I_root_Music(:,I_root_Music_iter)+SE_ind.*(1-misses_no); %[U27May13]
        miss_ind_I_root_Music(:,I_root_Music_iter) = miss_ind_I_root_Music(:,I_root_Music_iter)+misses_no; %[U27May13]
    
        if sum(misses_no) ~= 0
            miss_tot_I_root_Music(I_root_Music_iter) = miss_tot_I_root_Music(I_root_Music_iter)+1; %[U27May13]
        else
            CMSE_tot_I_root_Music(I_root_Music_iter) = CMSE_tot_I_root_Music(I_root_Music_iter)+SE_tot; %[U27May13]
        end
    end
end

%[U27May13]

MSE_tot_I_root_Music = MSE_tot_I_root_Music/MCiters; 
MSE_ind_I_root_Music = MSE_ind_I_root_Music/MCiters; 
CMSE_tot_I_root_Music = CMSE_tot_I_root_Music./(MCiters-miss_tot_I_root_Music); 
CMSE_ind_I_root_Music = CMSE_ind_I_root_Music./(MCiters-miss_ind_I_root_Music); 

gamma_mean = gamma_mean/MCiters;
gamma_var = gamma_var/MCiters-gamma_mean^2;

subspace_leakage_I_root_Music = subspace_leakage_I_root_Music/MCiters; % [U22Jan14]
subspace_leakage_I_root_Music_2 = subspace_leakage_I_root_Music_2/MCiters; % [U27Aug14]

disp('10*log10(CRB) = ');
disp(10*log10(CRB_MSE));
disp('10*log10(MSE_tot_I_root_Music) = ');
disp(10*log10(MSE_tot_I_root_Music));
disp('10*log10(MSE_ind_I_root_Music) = ');
disp(10*log10(MSE_ind_I_root_Music));
disp('10*log10(CMSE_tot_I_root_Music) = ');
disp(10*log10(CMSE_tot_I_root_Music));
disp('10*log10(CMSE_ind_I_root_Music) = ');
disp(10*log10(CMSE_ind_I_root_Music));
display(miss_tot_I_root_Music);
display(miss_ind_I_root_Music);
disp('Total detection Prob = ')
disp(1-miss_tot_I_root_Music/MCiters);
disp('Individual detection Prob = ')
disp(1-miss_ind_I_root_Music/MCiters);
display(subspace_swaps_tot_I_root_Music);
disp('Subspace swap Prob = ');
disp(subspace_swaps_tot_I_root_Music/MCiters);
display(subspace_leakage_I_root_Music);
disp('Subspace leakage variance = ')
disp(subspace_leakage_I_root_Music_2 - subspace_leakage_I_root_Music.^2);
display(gamma_mean);
display(gamma_var);

fhatI_root_Music_deg = fhatI_root_Music_rad*180/pi;
