% Performance analysis for various SNRs
% Iterative root-MUSIC for DOA estimation
% Currently one or two sources are considered.
% Correlated sources are also considere. (3 Oct. 2012)
% Mahdi Shaghaghi
% University of Alberta
% 10 September 2012

% Updated on: 3 October 2012

% Updated on: 20 Oct 2012 [U20Oct12]

% Updated on: 27 May 2013:[U27May13] Investigating the mechanism of the algorithm in detail.

% Updated on: 3 June 2013 [U3Jun13]

% Updated: 5 June 2013 [U5Jun13]: Automatic gamma selection

% Updated: 2 July 2013 [U2Jul13]: gamma selection based on minimizing the
%   squared Frobenius norm of the distance between the estimated and true
%   signal projection matrices: min ||hat( A(A'A)^(-1)A') - A(A'A)^(-1)A'||_F^2  

% Updated: 4 July 2013 [U4Jul13]: gamma selection based on minimizing the
%   angle between subspace spanned by hat(A) and subspace spanned by hat(E)
%   where hat(E) is the signal eigenvectors of hat(R) 

% Updated: 31 July 2013 [U31Jul13]: oracle gamma selection based on minimizing the
%   squared Frobenius norm of the distance between the estimated and true
%   covariance matrices (at the second iteration): min ||hat(R)_1 - R||_F^2

% Updated: 7 Jan 2014 [U7Jan14]: gamma selection based on Maximum
% Likelihooh objective. Built on
% i_root_MUSIC_DOA_est_sub_routine_v34.m
% Probabilty of subspace swap is also estimated using Monte Carlo
% simulations.

% Updated: 15 Jan 2014 [U15Jan14]: A new modified root-MUSIC method is used.
% Specifically, different combinations of the roots are considered, and the
% one with minimum ML objective is used as the output of the root-MUSIC
% method.
% Built on i_root_MUSIC_DOA_est_sub_routine_v60.m

% Updated: 22 Jan 2014 [U22Jan14]: Subspace leakage is investigated over 
% iterations. Subspace leakage is defined as 
% rho = 1 - 1/K * Tr( PAhat * PA) 

% Updated: 12 Feb 2014 [U12Feb14]: Unitary root-MUSIC is used.
% Built on Performance_analysis_v61.m

% Updated: 18 Feb 2014 [U18Feb14]: root-swap-unitary-root-MUSIC is
% considered.

% Updated: 12 Mar 2014: [U12Mar14]: CRB is computed.

% Updated: 17 Mar 2014: [U17Mar14]: 
% a) Stochastic ML objectice function is
% also considered. ref: eq (2.20), Stoica, 1990, Performance Study of 
% Conditional and Unconditional Direction-of-Arrival Estimation
% b) Conventional beamformer is tested.

% Updated: 31 Mar 2014: [U31Mar14]: Pseudo-Noise resampling is tested

% Updated: 20 Apr 2014: [U20Apr14]: gamma * ( U + U' ) is subtracted from
% the resampled covariance matrix (in pseudo_noise_resample function).  

% Updated: 22 Apr 2014: [U22Apr14]: gamma * ( U + U' ) is subtracted from
% the resampled covariance matrix (in pseudo_noise_resample function) even
% at the first iteration. The initial value of gamma is used here.

% Updated:5 June 2014 [U5Jun14]: R_true corrected!

% Updated: 27 Aug 2014 [U27Aug14]: Subspace leakage variance is obtained through simulation. 


clear 
clc
tic

current_version = 'v74';
DOA_method = 'root-MUSIC'; 
% DOA_method = 'root-swap-root-MUSIC';
% DOA_method = 'unitary-root-MUSIC'; 
% DOA_method = 'root-swap-unitary-root-MUSIC';

ML_method = 'Stochastic';
% ML_method = 'Deterministic';

M = 10; % Window size (or the number of array elements). 
N = 10; % The number of snapshots or the number of samples used for 
        % estimating the sample covariance matrix 
d_lambda = 0.5; % d/lambda   

P = 0; % Pseudo-noise resampling numbers [U31Mar14]

p_r = 1; 
q_r = 0;
% In the root-swap-root-MUSIC/root-swap-unitary-root-MUSIC method, 
% the first p_r roots are picked, the last q_r roots are discarded, 
% and K - p roots are chosen from the 
% remaining roots based on the ML objective. [U15Jan14]

I_root_Music_max_itr = 2; % Maximum number of iteration for the iterative root-Music method 
freqs_deg = [35 37]'; % freqs should be in [-90,90] range
error_trsh = 1*pi/180; % A miss is recorded if error (in radian) in estimating each frequncy (DOA) is larger than this threshold
CorrelationCoef = 0; % 0.9;
MCiters = 100000; % Number of Monte Carlo iterations
SNR_vec = 16; % 6:2:28; % 14:2:34 %(dB)

gamma = 0.5; % Fixeed gamma used when auto_gamma_selection == 0. 
auto_gamma_selection = true; % set to false for a fixed gamma  
gamma_grid_size = 11; % Number of points between 0 to 1 used for gamma selection.

theta = -(pi/2):0.01:(pi/2); % Used as the grid for conventional beamformer. [U17Mar14]

sigma2noise = 1; % Noise variance
K = length(freqs_deg); % Number of complex exponentials (or the number of sources). 
freqs_rad = freqs_deg*pi/180;
if CorrelationCoef == 0
    cr = 0;
else
    cr = (1-sqrt(1-CorrelationCoef^2))/CorrelationCoef;
end;
SourceCorrelation = [1 cr;cr 1]/sqrt(1+cr^2);
SNR_len = length(SNR_vec);

display(current_version);
display(M);
display(N);
display(P);
display(CorrelationCoef);
display(DOA_method);
display(ML_method);
display(gamma);
display(auto_gamma_selection);
display(gamma_grid_size);

MSE_ind_I_root_Music_data_dB = zeros(SNR_len,K,I_root_Music_max_itr); %[U27May13] unconditional MSE (in radians^2)
CMSE_ind_I_root_Music_data_dB = zeros(SNR_len,K,I_root_Music_max_itr); %[U27May13] conditioned on successful detection
miss_ind_I_root_Music_data = zeros(SNR_len,K,I_root_Music_max_itr); %[U27May13] total number of misses in frequency/DOA estimation

MSE_tot_I_root_Music_data_dB = zeros(SNR_len,I_root_Music_max_itr); %[U27May13] total (all frequencies/DOAs)
CMSE_tot_I_root_Music_data_dB = zeros(SNR_len,I_root_Music_max_itr); %[U27May13] 
miss_tot_I_root_Music_data = zeros(SNR_len,I_root_Music_max_itr); %[U27May13]

gamma_mean_data = zeros(SNR_len,1);%[U5Jun13]
gamma_var_data = zeros(SNR_len,1);%[U5Jun13]

subspace_swaps_tot_I_root_Music_data = zeros(SNR_len,I_root_Music_max_itr); %[U7Jan14]
subspace_leakage_I_root_Music_data = zeros(SNR_len,I_root_Music_max_itr); %[U22Jan14]
subspace_leakage_I_root_Music_variance_data = zeros(SNR_len,I_root_Music_max_itr); %[U27Aug14]
CRB_MSE_data = zeros(SNR_len,1); %[U12Mar14]

test_fail_count_data = zeros(SNR_len,I_root_Music_max_itr); % [U31Mar14]

for SNR_iter = 1:SNR_len
    SNR = SNR_vec(SNR_iter); % = 10*log10(sigma2source/sigma2noise) (dB)
    display(SNR);
    sigma2source = 10^(0.1*SNR)*sigma2noise;  % Signal power
    i_unitary_root_MUSIC_DOA_est_sub_routine_v74; 
       
    test_fail_count_data(SNR_iter,:) = test_fail_count; % [U31Mar14]
    
    MSE_ind_I_root_Music_data_dB(SNR_iter,:,:) = 10*log10(MSE_ind_I_root_Music);
    CMSE_ind_I_root_Music_data_dB(SNR_iter,:,:) = 10*log10(CMSE_ind_I_root_Music);
    miss_ind_I_root_Music_data(SNR_iter,:,:) = miss_ind_I_root_Music;

    MSE_tot_I_root_Music_data_dB(SNR_iter,:) = 10*log10(MSE_tot_I_root_Music);
    CMSE_tot_I_root_Music_data_dB(SNR_iter,:) = 10*log10(CMSE_tot_I_root_Music);
    miss_tot_I_root_Music_data(SNR_iter,:) = miss_tot_I_root_Music;
    
    gamma_mean_data(SNR_iter) = gamma_mean;
    gamma_var_data(SNR_iter) = gamma_var;
    
    subspace_swaps_tot_I_root_Music_data(SNR_iter,:) = subspace_swaps_tot_I_root_Music; 
    subspace_leakage_I_root_Music_data(SNR_iter,:) = subspace_leakage_I_root_Music;
    subspace_leakage_I_root_Music_variance_data(SNR_iter,:) = subspace_leakage_I_root_Music_2 - subspace_leakage_I_root_Music.^2;
    
    CRB_MSE_data(SNR_iter) = 10*log10(CRB_MSE);
    
end

% close all
% plot(theta*180/pi,f_CBF);

toc
