% University of Alberta 
% Mahdi Shaghaghi
% 17 March 2014

function [freqs_rad, f_CBF, freqs_left_rad, freqs_right_rad] = conventional_beamformer(R, M, K, theta, d_lambda)

idxm = (0:(M-1))'; 
GridSize = length(theta);
f_CBF = zeros(GridSize,1);
for i = 1:GridSize
    a = 1/sqrt(M)*exp(-1i*2*pi*d_lambda*sin(theta(i))*idxm);
    f_CBF(i) = real((a')* R *a);
end

f_CBF = -f_CBF; % Since the following code looks for minimums, but we are interested in maximums. 

leftdiff = zeros(GridSize,1);
leftdiff(1) = sign(f_CBF(1)-f_CBF(GridSize));
leftdiff(2:GridSize) = sign(f_CBF(2:GridSize)-f_CBF(1:(GridSize-1)));
rightdiff = zeros(GridSize,1);
rightdiff(GridSize) = sign(f_CBF(GridSize)-f_CBF(1));
rightdiff(1:(GridSize-1)) = sign(f_CBF(1:(GridSize-1))-f_CBF(2:GridSize));

for i = 2:GridSize
    if (leftdiff(i) == 0)
        leftdiff(i) = leftdiff(i-1);
    end 
end
if (leftdiff(1) == 0)
    leftdiff(1) = leftdiff(GridSize);
    i = 2;
    while ((leftdiff(i) == 0) && (i <= GridSize))
        leftdiff(i) = leftdiff(i-1);
        i = i+1;
    end
end
    
for i = (GridSize-1):-1:1
    if (rightdiff(i) == 0)
        rightdiff(i) = rightdiff(i+1);
    end 
end
if (rightdiff(GridSize) == 0)
    rightdiff(GridSize) = rightdiff(1);
    i = GridSize-1;
    while ((rightdiff(i) == 0) && (i >= 1))
        rightdiff(i) = rightdiff(i+1);
        i = i-1;
    end
end

localminima = find((leftdiff<0)&(rightdiff<0));

fhatCBF_rad = zeros(K,1);
fhatCBF_idx = zeros(K,1);
for i = 1:K
    [~,idx] = min(f_CBF(localminima));
    fhatCBF_rad(i) = theta(localminima(idx));
    fhatCBF_idx(i) = localminima(idx);
    localminima(idx) = [];
end

[freqs_rad, idx] = sort(fhatCBF_rad);
fhatCBF_idx = fhatCBF_idx(idx);

f_CBF = -f_CBF; 

freqs_left_rad = freqs_rad;
freqs_right_rad = freqs_rad;
for i = 1:K
    local_max = f_CBF(fhatCBF_idx(i)); 

    idx = fhatCBF_idx(i)-1;
    if (idx == 0) 
        idx = GridSize;
    end
    while ((f_CBF(idx) > 0.5*local_max) && (leftdiff(idx) ~= rightdiff(idx)))
        idx = idx - 1;
        if (idx == 0)
            idx = GridSize;
        end
    end
    freqs_left_rad(i) = theta(idx);

    idx = fhatCBF_idx(i)+1;
    if (idx == GridSize+1) 
        idx = 1;
    end
    while ((f_CBF(idx) > 0.5*local_max) && (leftdiff(idx) ~= rightdiff(idx)))
        idx = idx + 1;
        if (idx == GridSize+1)
            idx = 1;
        end
    end
    freqs_right_rad(i) = theta(idx);
end


% Checking if there is a period starting (left boundary) before pi/2 and
% ending (right boundary) after -pi/2. Such an interval will be split into
% two intervals: one starting from -pi/2 to the right boundary and the other
% from the left boundary to pi/2.

for i = 1:K
    if (freqs_left_rad(i)>freqs_right_rad(i))
        freqs_left_rad(end+1) = freqs_left_rad(i);
        freqs_right_rad(end+1) = pi/2;       
        freqs_left_rad(i) = -pi/2;
    end
end





















