function [fhatroot_Proposed_rad] = nununi_6_plus_any(R,K,M,tt,gg,x0,QQ,N)

%% Estimating Q (Phase 1)
Q=diag(diag(R));
   
for ii=1:tt
[UU,DDDD]=eig(R,Q);
[~,idx] = sort(real(diag(DDDD))); % Ascending order: lambdahat1 <= lambdahat2 <= ...
UU1 = UU(:,idx);
UU = UU1(:,1:(M-K));
UU1 = UU*(UU');
UU = R*UU1 + UU1*R;
Q=0.5*diag(diag(UU))*diag(1./diag(UU1));
end


%% Phase 2

x0=((Q)^(-0.5))*x0;
[US,D0,~]=svd(x0,'econ');
US=US(:,1:K);
dd=D0(1:K,1:K);


US=(Q^0.5)*US;
scnum=K;
ind=[];
U_bar = zeros(M,K);
for ii=1:K
U_bar(:,ii) = fft(US(:,ii));
end

WL=zeros(M,scnum);
WLL=zeros(M,scnum);
kk=0:M-1;
idx=1:scnum;
for ii=1:M
WL(ii,:)=exp(-1j*2*pi*kk(ii)*idx/M);
WLL(ii,:)=exp(-1j*2*pi*kk(ii)*(idx-1)/M);
end
WW=zeros(M,M);
idx=0:M-1;
for ii=1:M
WW(ii,:)=exp(-1j*2*pi*kk(ii)*idx/M);
end


for zz=1:length(QQ)
H=[];
h=[];

[~,s1]=maxk(abs(U_bar(:,1)),QQ(zz));

Z1=zeros(QQ(zz),M);
for ii=1:QQ(zz)
Z1(ii,s1(ii))=1;
end
B=null((Z1*WLL).');
B_her=B.';
for ii=1:K
S1=U_bar(s1,ii);
T1=diag(S1);
H=[H;B_her*T1*WL(s1,:)];
h=[h;-B_her*S1];
end
a=H\h;
CC=B_her*(eye(QQ(zz))+diag(WL(s1,:)*a))*WW(s1,:);
CC=inv(CC*Q*(CC'));
WA=kron(dd^2,CC);
for ii=1:gg
a=inv(H'*WA*H)*(H')*WA*h;
CC=B_her*(eye(QQ(zz))+diag(WL(s1,:)*a))*WW(s1,:);
CC=inv(CC*Q*(CC'));
WA=kron(dd^2,CC);
end
v=roots([1;a]);
C1=angle(v);
C2=asin(-C1/pi);

ind=[ind;C2];



end
ind22=ind(K+1:end);

%% Phase 3

% Step 1
theta=-(pi/2):0.01:(pi/2);
[ind1] = cb_pre2(R, M, theta, 0.5,ind,K);


if length(ind1) >= K
ind=ind1;
else
ind=ind22;  
end


% Step 2
[ind3,ind4] = detect_nonuni(R, K, ind,M,Q);
ind=ind4;


% Step 3
idx_combinations = nchoosek(1:length(ind), K-1 );
n = size(idx_combinations,1); % number of combinations.


R_tilde = (Q^(-0.5))*R*(Q^(-0.5));

idxR = (0 : (M - 1))';
Ahat = zeros(M, K-1);
ML_objective = zeros(n, 1);

for i = 1:n
    idx_tmp =  idx_combinations(i,:);
    
    for k = 1:K-1
        Ahat(:,k) = exp(-1j*pi*sin(ind(idx_tmp(k)))*idxR);
    end
    Ahat = (Q^(-0.5))*Ahat;
    Ahat = Ahat/sqrt(M); % So that each column of Ahat has unit norm.
    PAhat = Ahat*((Ahat')*Ahat)^(-1)*(Ahat');
    PA_orthhat = eye(M,M) - PAhat;
    aaa1=exp(-1j*pi*sin(ind3)*idxR);
    nu1= (PA_orthhat*(Q^(-0.5))*aaa1)/norm(PA_orthhat*(Q^(-0.5))*aaa1);
    ML_objective(i) =  real( trace(  ( (PA_orthhat-nu1*(nu1')) * R_tilde ) ));

       
end

[~,idx] = min(ML_objective);
idx_tmp =  idx_combinations(idx,:);
fhatroot_Proposed_rad=sort([ind(idx_tmp); ind3]);


end