% plot_lb.m
%   plot the lower bound of the probability that the zigzag-scan-based
%   permutatoin is acceptabl
%   Eq. (10) in the paper
%   Figs. 1--3 in the paper
% 
% Written: Hao Fang
% Created: Nov. 2012

close all;
clear;
clc;

% alpha = 0.2:0.2:0.8;
alpha = 0.2:0.1:0.5;
r0 = 3;
r1 = 5;
r2 = (r1+1):50;

lower_bound = zeros(length(alpha), length(r2));

LineSpec = {'-', '--', '-.', '-o'};
figure('Position',[50 50 800 500]);
hold all;
grid on;

max_r = zeros(1, length(alpha));
epsilon = 1e-4;
for aa = 1:length(alpha)
    for rr=1:length(r2)
        p = zeros(1, r2(rr));
        p(r0+1:r1) = 1;
        p((r1+1):r2(rr)) = exp(-alpha(aa).*([(r1+1):r2(rr)]-r0-1));
        
        lower_bound(aa, rr) = layer_lb(r0, r1, r2(rr), p);
        if rr > 1 && lower_bound(aa, rr) - lower_bound(aa, rr-1) < epsilon
            max_r(aa) = rr;
            break;
        end
    end
    plot(r2(1:max_r(aa)), lower_bound(aa, 1:max_r(aa)), LineSpec{aa}, 'LineWidth', 4);
end


set(gca, 'FontSize', 14, ...
    'FontWeight', 'Bold');
xlabel('Layer Index r_2', 'FontSize', 20, 'FontWeight', 'Bold');
ylabel('Lower Bound', 'FontSize', 20, 'FontWeight', 'Bold');
% h_legend = legend('\alpha=0.2', '\alpha=0.4', '\alpha=0.6', '\alpha=0.8', ...
%     'Location', 'SouthEast');
h_legend = legend('\alpha=0.2', '\alpha=0.3', '\alpha=0.4', '\alpha=0.5', ...
    'Location', 'SouthEast');
set(h_legend, 'FontSize', 15);
set(h_legend, 'FontWeight', 'Bold');