function lb = layer_lb(r0, r1, r2, p)
% layer_lb.m
%   Calculate the lower bound of Pr(zigzag-scan-based permutation is acceptable)
%   for layer model signal
%   Eq. (10) in the paper
%
% Written: Hao Fang
% Created: Nov. 2012

kj = [(r1-r0)*ones(1, r0) (r1-r0):-1:1 0*ones(1,r2-r1)];
mj = [(r1+1)*ones(1,r1+1) r1+2:r2];
l = ceil((r0+r2+1)/2);

prob_1 = 1;
for m = r1+1:r2
    prob_1 = prob_1 * (1 - p(m))^m;
end

prob_2 = 1;
for j = 1:r2
    prob_2_1 = 1;
    for k = (kj(j)+1):min([l, r2-r0, r2-j+1])
        %prob_2_1 = prob_2_1 + (sum( p(mj(j):r2) ./ (1-p(mj(j):r2)) ))^(k-kj(j)) - sum( (p(mj(j):r2) ./ (1-p(mj(j):r2))).^(k-kj(j)) );
        prob_2_1 = prob_2_1 + it_sum(p, mj(j), r2, 0, k-kj(j));
    end
    prob_2 = prob_2 * prob_2_1;
end

lb = 1-prob_1*prob_2;
end
