function Y = parallel_cs_encoder(X, A, transform_handler, options)
% parallel_cs_encoder.m
%   parallel compressed sensing encoder
%
% Input:
%   X: input 2D sparse or compressible signal.
%   A: the measurement matrix.
%   transform_handler: transformation handler. include both block
%   parititioning and permutation.
%   options: transformation handler parameters. usually including the block
%   dimension.
%
% Output:
%   Y: CS measurements.
%
% Special Note:
% The transformation handler can only include block partition without
% permutation.
% The permutation is related to the block partitioning scheme.
% 
% Written: Hao Fang
% Created: Sep. 2012

% transform the 2D signal: block partitioning and permutation
if nargin == 2
    X_sharp = X;
end
if nargin == 3
    X_sharp = transform_handler(X);
end
if nargin == 4
    X_sharp = transform_handler(X, options);
end

% parallel CS encoding
Y = A * X_sharp;

end