function rec_X = parallel_cs_decoder_l1magic(Y, A, inv_transform_handler, options)
% parallel_cs_decoder_l1magic.m
%   parallel compressed sensing decoder using l1magic solver
%
% Requirement:
%   l1magic package: http://users.ece.gatech.edu/~justin/l1magic/
% Input:
%   Y: CS measurements.
%   A: the measurement matrix.
%   inv_transform_handler: inverse transformation handler.
%   options: inverse transformation handler parameters. usually including
%   the block dimension.
%
% Output:
%   rec_X: reconstructed 2D signal.
%
% Written: Hao Fang
% Created: Apr. 2013

dims(1) = size(A, 2);
dims(2) = size(Y, 2);

% parallel CS decoding
rec_X_sharp = zeros(dims(1), dims(2));
for i = 1:dims(2)
    disp(sprintf('col: %d', i));
    if (any(Y(:,i)) == 1) % if all measurements are 0s, then return 0 vector
        rec_X_sharp(:,i) = l1eq_pd(A'*Y(:,i), A, A', Y(:,i));
    end
end


if nargin == 2
    rec_X = rec_X_sharp;
end
if nargin == 3
    rec_X = inv_transform_handler(rec_X_sharp);
end
if nargin == 4
    rec_X = inv_transform_handler(rec_X_sharp, options);
end

end