function rec_X = parallel_cs_decoder(Y, A, inv_transform_handler, options)
% parallel_cs_decoder.m
%   parallel compressed sensing decoder using cvx toolbox
%
% Requirement:
%   CVX toolbox: http://cvxr.com/cvx/
% Input:
%   Y: CS measurements.
%   A: the measurement matrix.
%   inv_transform_handler: inverse transformation handler.
%   options: inverse transformation handler parameters. usually including
%   the block dimension.
%
% Output:
%   rec_X: reconstructed 2D signal.
%
% Written: Hao Fang
% Created: Sep. 2012

p = 1;

dims(1) = size(A, 2);
dims(2) = size(Y, 2);

% parallel CS decoding
rec_X_sharp = zeros(dims(1), dims(2));
for i = 1:dims(2)
    disp(sprintf('col: %d', i));
    cvx_begin quiet
    variable dec2d_p(dims(1),1);
    dual variable y_1;
    minimize( norm( dec2d_p, p ) );
    subject to
    y_1 : A * dec2d_p == Y(:,i);
    cvx_end
    rec_X_sharp(:,i) = dec2d_p;
end


if nargin == 2
    rec_X = rec_X_sharp;
end
if nargin == 3
    rec_X = inv_transform_handler(rec_X_sharp);
end
if nargin == 4
    rec_X = inv_transform_handler(rec_X_sharp, options);
end

end