#ifndef TJ_PARTITION_H
#define TJ_PARTITION_H

#if defined(SYMMETRY) && (SYMMINTEGRATION == 7)

class CellEntry {
public:
  unsigned int first, length;
  unsigned int max_ival, max_ival_count;
  int splitted;
  bool in_neighbourhood_stack;
  bool initial;
  CellEntry *next;
};

class TJ_Partition;

#include <stdlib.h>
#include <stdio.h>
#include "TJ_heap.H"
#include "net.H"


class TJ_Partition {
  Heap split_set;
  unsigned int N;

  void split_cell_plain(CellEntry *cell);
  //void sortandsplit_cell1_plain(CellEntry *cell);
  //void sortandsplit_cell255_plain(CellEntry *cell);

  void split_neighbourhood();
  void do_refine_to_equitable2();
public:
  CellEntry *cells;
  CellEntry *free_cells;
  CellEntry *first_cell;
  Node **elements;

  bool shellsort_cell(CellEntry *cell);
  CellEntry *sortandsplit_cell1(CellEntry *cell);
  CellEntry *sortandsplit_cell255(CellEntry *cell);
  CellEntry *split_cell(CellEntry *cell);
  void clear_ivs(CellEntry *cell);

  void init();
  bool refine(unsigned int (*inv)(unsigned int));

  void refine_according_to_marking();

  void refine_pre_and_postset();

  void refine_to_equitable2();
  void refine_to_equitable2(CellEntry *new_singleton_cell);

  bool is_discrete() {return(free_cells == 0); }
  void print(FILE *fp);
  void print_signature(FILE *fp);
};

#endif
#endif
