/*
 * The head data structure, from Sedgewick: "Algorithms in C"
 */

#ifndef TJ_HEAP_H
#define TJ_HEAP_H

#include <assert.h>
#include <limits.h>
#include "TJ_defs.H"

class Heap
{
#ifdef TJ_DEBUG
  unsigned int N;
#endif
  unsigned int n;
  unsigned int *array;
  void upheap(unsigned int k);
  void downheap(unsigned int k);
public:
  Heap() {array = 0; n = 0; }
  void init(unsigned int size);

  bool is_empty() {return(n==0); }
  unsigned int size() {return n;}
  void clear() {n = 0;}
  void insert(unsigned int v);
  unsigned int remove();
};


#endif
